/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.DefaultDistributedSet;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.SetBuilder;

public class DefaultSetBuilder<E>
implements SetBuilder<E> {
    private Serializer serializer;
    private String name;
    private final Database database;
    private boolean readOnly;

    public DefaultSetBuilder(Database database) {
        this.database = (Database)Preconditions.checkNotNull((Object)database);
    }

    public SetBuilder<E> withName(String name) {
        Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0);
        this.name = name;
        return this;
    }

    public SetBuilder<E> withSerializer(Serializer serializer) {
        Preconditions.checkArgument((serializer != null ? 1 : 0) != 0);
        this.serializer = serializer;
        return this;
    }

    public SetBuilder<E> withUpdatesDisabled() {
        this.readOnly = true;
        return this;
    }

    private boolean validInputs() {
        return this.name != null && this.serializer != null;
    }

    public Set<E> build() {
        Preconditions.checkState((boolean)this.validInputs());
        return new DefaultDistributedSet(this.name, this.database, this.serializer, this.readOnly);
    }
}

