/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.onosproject.store.service.DatabaseUpdate;
import org.onosproject.store.service.Transaction;

public class DefaultTransaction
implements Transaction {
    private final long transactionId;
    private final List<DatabaseUpdate> updates;
    private final Transaction.State state;
    private final long lastUpdated;

    public DefaultTransaction(long transactionId, List<DatabaseUpdate> updates) {
        this(transactionId, updates, Transaction.State.PREPARING, System.currentTimeMillis());
    }

    private DefaultTransaction(long transactionId, List<DatabaseUpdate> updates, Transaction.State state, long lastUpdated) {
        this.transactionId = transactionId;
        this.updates = ImmutableList.copyOf(updates);
        this.state = state;
        this.lastUpdated = lastUpdated;
    }

    public long id() {
        return this.transactionId;
    }

    public List<DatabaseUpdate> updates() {
        return this.updates;
    }

    public Transaction.State state() {
        return this.state;
    }

    public Transaction transition(Transaction.State newState) {
        return new DefaultTransaction(this.transactionId, this.updates, newState, System.currentTimeMillis());
    }

    public long lastUpdated() {
        return this.lastUpdated;
    }
}

