/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.Map;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.DefaultConsistentMap;
import org.onosproject.store.consistent.impl.DefaultTransaction;
import org.onosproject.store.consistent.impl.DefaultTransactionalMap;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionException;
import org.onosproject.store.service.TransactionalMap;

public class DefaultTransactionContext
implements TransactionContext {
    private static final String TX_NOT_OPEN_ERROR = "Transaction Context is not open";
    private final Map<String, DefaultTransactionalMap> txMaps = Maps.newConcurrentMap();
    private boolean isOpen = false;
    private final Database database;
    private final long transactionId;

    public DefaultTransactionContext(Database database, long transactionId) {
        this.database = (Database)Preconditions.checkNotNull((Object)database);
        this.transactionId = transactionId;
    }

    public long transactionId() {
        return this.transactionId;
    }

    public void begin() {
        Preconditions.checkState((!this.isOpen ? 1 : 0) != 0, (Object)"Transaction Context is already open");
        this.isOpen = true;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public <K, V> TransactionalMap<K, V> getTransactionalMap(String mapName, Serializer serializer) {
        Preconditions.checkState((boolean)this.isOpen, (Object)TX_NOT_OPEN_ERROR);
        Preconditions.checkNotNull((Object)mapName);
        Preconditions.checkNotNull((Object)serializer);
        return this.txMaps.computeIfAbsent(mapName, name -> new DefaultTransactionalMap((String)name, new DefaultConsistentMap((String)name, this.database, serializer, false), this, serializer));
    }

    public void commit() {
        Preconditions.checkState((boolean)this.isOpen, (Object)TX_NOT_OPEN_ERROR);
        try {
            LinkedList updates = Lists.newLinkedList();
            this.txMaps.values().forEach(m -> updates.addAll(m.prepareDatabaseUpdates()));
            this.database.prepareAndCommit(new DefaultTransaction(this.transactionId, updates));
        }
        catch (Exception e) {
            this.abort();
            throw new TransactionException((Throwable)e);
        }
        finally {
            this.isOpen = false;
        }
    }

    public void abort() {
        Preconditions.checkState((boolean)this.isOpen, (Object)TX_NOT_OPEN_ERROR);
        this.txMaps.values().forEach(m -> m.rollback());
    }
}

