/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.DefaultTransactionContext;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionContextBuilder;

public class DefaultTransactionContextBuilder
implements TransactionContextBuilder {
    private boolean partitionsEnabled = true;
    private final Database partitionedDatabase;
    private final Database inMemoryDatabase;
    private final long transactionId;

    public DefaultTransactionContextBuilder(Database inMemoryDatabase, Database partitionedDatabase, long transactionId) {
        this.partitionedDatabase = partitionedDatabase;
        this.inMemoryDatabase = inMemoryDatabase;
        this.transactionId = transactionId;
    }

    public TransactionContextBuilder withPartitionsDisabled() {
        this.partitionsEnabled = false;
        return this;
    }

    public TransactionContext build() {
        return new DefaultTransactionContext(this.partitionsEnabled ? this.partitionedDatabase : this.inMemoryDatabase, this.transactionId);
    }
}

