/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ClusterEventListener;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipEventListener;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.event.EventDeliveryService;
import org.onosproject.event.EventListener;
import org.onosproject.event.ListenerRegistry;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class DistributedLeadershipManager
implements LeadershipService {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected EventDeliveryService eventDispatcher;
    private static final MessageSubject LEADERSHIP_EVENT_MESSAGE_SUBJECT = new MessageSubject("distributed-leadership-manager-events");
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ExecutorService messageHandlingExecutor;
    private ScheduledExecutorService electionRunner;
    private ScheduledExecutorService lockExecutor;
    private ScheduledExecutorService staleLeadershipPurgeExecutor;
    private ScheduledExecutorService leadershipRefresher;
    private ConsistentMap<String, NodeId> leaderMap;
    private ConsistentMap<String, List<NodeId>> candidateMap;
    private ListenerRegistry<LeadershipEvent, LeadershipEventListener> listenerRegistry;
    private final Map<String, Leadership> leaderBoard = Maps.newConcurrentMap();
    private final Map<String, Leadership> candidateBoard = Maps.newConcurrentMap();
    private final ClusterEventListener clusterEventListener = new InternalClusterEventListener();
    private NodeId localNodeId;
    private Set<String> activeTopics = Sets.newConcurrentHashSet();
    private Map<String, CompletableFuture<Leadership>> pendingFutures = Maps.newConcurrentMap();
    private static final int WAIT_BEFORE_RETRY_MILLIS = 150;
    private static final int DELAY_BETWEEN_LEADER_LOCK_ATTEMPTS_SEC = 2;
    private static final int LEADERSHIP_REFRESH_INTERVAL_SEC = 2;
    private static final int DELAY_BETWEEN_STALE_LEADERSHIP_PURGE_ATTEMPTS_SEC = 2;
    private final AtomicBoolean staleLeadershipPurgeScheduled = new AtomicBoolean(false);
    private static final Serializer SERIALIZER = Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).build());

    @Activate
    public void activate() {
        this.leaderMap = this.storageService.consistentMapBuilder().withName("onos-topic-leaders").withSerializer(SERIALIZER).withPartitionsDisabled().build();
        this.candidateMap = this.storageService.consistentMapBuilder().withName("onos-topic-candidates").withSerializer(SERIALIZER).withPartitionsDisabled().build();
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.messageHandlingExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/store/leadership", (String)"message-handler"));
        this.electionRunner = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/store/leadership", (String)"election-runner"));
        this.lockExecutor = Executors.newScheduledThreadPool(4, Tools.groupedThreads((String)"onos/store/leadership", (String)"election-thread-%d"));
        this.staleLeadershipPurgeExecutor = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/store/leadership", (String)"stale-leadership-evictor"));
        this.leadershipRefresher = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/store/leadership", (String)"refresh-thread"));
        this.clusterCommunicator.addSubscriber(LEADERSHIP_EVENT_MESSAGE_SUBJECT, arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), this::onLeadershipEvent, (Executor)this.messageHandlingExecutor);
        this.clusterService.addListener(this.clusterEventListener);
        this.electionRunner.scheduleWithFixedDelay(this::electLeaders, 0L, 2L, TimeUnit.SECONDS);
        this.leadershipRefresher.scheduleWithFixedDelay(this::refreshLeaderBoard, 0L, 2L, TimeUnit.SECONDS);
        this.listenerRegistry = new ListenerRegistry();
        this.eventDispatcher.addSink(LeadershipEvent.class, this.listenerRegistry);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.leaderBoard.forEach((topic, leadership) -> {
            if (this.localNodeId.equals((Object)leadership.leader())) {
                this.withdraw((String)topic);
            }
        });
        this.clusterService.removeListener(this.clusterEventListener);
        this.eventDispatcher.removeSink(LeadershipEvent.class);
        this.clusterCommunicator.removeSubscriber(LEADERSHIP_EVENT_MESSAGE_SUBJECT);
        this.electionRunner.shutdown();
        this.messageHandlingExecutor.shutdown();
        this.lockExecutor.shutdown();
        this.staleLeadershipPurgeExecutor.shutdown();
        this.leadershipRefresher.shutdown();
        this.log.info("Stopped");
    }

    public Map<String, Leadership> getLeaderBoard() {
        return ImmutableMap.copyOf(this.leaderBoard);
    }

    public Map<String, List<NodeId>> getCandidates() {
        return Maps.toMap(this.candidateBoard.keySet(), this::getCandidates);
    }

    public List<NodeId> getCandidates(String path) {
        Leadership current = this.candidateBoard.get(path);
        return current == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)current.candidates());
    }

    public NodeId getLeader(String path) {
        Leadership leadership = this.leaderBoard.get(path);
        return leadership != null ? leadership.leader() : null;
    }

    public Leadership getLeadership(String path) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0);
        return this.leaderBoard.get(path);
    }

    public Set<String> ownedTopics(NodeId nodeId) {
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0);
        return this.leaderBoard.entrySet().stream().filter(entry -> nodeId.equals((Object)((Leadership)entry.getValue()).leader())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public CompletableFuture<Leadership> runForLeadership(String path) {
        this.log.debug("Running for leadership for topic: {}", (Object)path);
        CompletableFuture<Leadership> resultFuture = new CompletableFuture<Leadership>();
        this.doRunForLeadership(path, resultFuture);
        return resultFuture;
    }

    private void doRunForLeadership(String path, CompletableFuture<Leadership> future) {
        try {
            Versioned candidates = this.candidateMap.computeIf((Object)path, currentList -> currentList == null || !currentList.contains(this.localNodeId), (topic, currentList) -> {
                if (currentList == null) {
                    return ImmutableList.of((Object)this.localNodeId);
                }
                LinkedList newList = Lists.newLinkedList();
                newList.addAll(currentList);
                newList.add(this.localNodeId);
                return newList;
            });
            this.publish(new LeadershipEvent(LeadershipEvent.Type.CANDIDATES_CHANGED, new Leadership(path, (List)candidates.value(), candidates.version(), candidates.creationTime())));
            this.log.debug("In the leadership race for topic {} with candidates {}", (Object)path, (Object)candidates);
            this.activeTopics.add(path);
            Leadership leadership = this.electLeader(path, (List)candidates.value());
            if (leadership == null) {
                this.pendingFutures.put(path, future);
            } else {
                future.complete(leadership);
            }
        }
        catch (ConsistentMapException e) {
            this.log.debug("Failed to enter topic leader race for {}. Retrying.", (Object)path, (Object)e);
            this.rerunForLeadership(path, future);
        }
    }

    public CompletableFuture<Void> withdraw(String path) {
        this.activeTopics.remove(path);
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        this.doWithdraw(path, resultFuture);
        return resultFuture;
    }

    private void doWithdraw(String path, CompletableFuture<Void> future) {
        if (this.activeTopics.contains(path)) {
            future.completeExceptionally(new CancellationException(String.format("%s is now a active topic", path)));
        }
        try {
            Versioned candidates;
            ArrayList candidateList;
            Versioned leader = this.leaderMap.get((Object)path);
            if (leader != null && Objects.equals(leader.value(), this.localNodeId) && this.leaderMap.remove((Object)path, leader.version())) {
                this.log.debug("Gave up leadership for {}", (Object)path);
                future.complete(null);
                this.publish(new LeadershipEvent(LeadershipEvent.Type.LEADER_BOOTED, new Leadership(path, this.localNodeId, leader.version(), leader.creationTime())));
            }
            ArrayList arrayList = candidateList = (candidates = this.candidateMap.get((Object)path)) != null ? Lists.newArrayList((Iterable)((Iterable)candidates.value())) : Lists.newArrayList();
            if (!candidateList.remove(this.localNodeId)) {
                future.complete(null);
                return;
            }
            if (this.candidateMap.replace((Object)path, candidates.version(), (Object)candidateList)) {
                Versioned newCandidates = this.candidateMap.get((Object)path);
                future.complete(null);
                this.publish(new LeadershipEvent(LeadershipEvent.Type.CANDIDATES_CHANGED, new Leadership(path, (List)newCandidates.value(), newCandidates.version(), newCandidates.creationTime())));
            } else {
                this.log.debug("Failed to withdraw from candidates list for {}. Will retry", (Object)path);
                this.retryWithdraw(path, future);
            }
        }
        catch (Exception e) {
            this.log.debug("Failed to verify (and clear) any lock this node might be holding for {}", (Object)path, (Object)e);
            this.retryWithdraw(path, future);
        }
    }

    public boolean stepdown(String path) {
        if (!this.activeTopics.contains(path) || !Objects.equals(this.localNodeId, this.getLeader(path))) {
            return false;
        }
        try {
            Versioned leader = this.leaderMap.get((Object)path);
            if (leader != null && Objects.equals(leader.value(), this.localNodeId) && this.leaderMap.remove((Object)path, leader.version())) {
                this.log.debug("Stepped down from leadership for {}", (Object)path);
                this.publish(new LeadershipEvent(LeadershipEvent.Type.LEADER_BOOTED, new Leadership(path, this.localNodeId, leader.version(), leader.creationTime())));
                return true;
            }
        }
        catch (Exception e) {
            this.log.warn("Error executing stepdown for {}", (Object)path, (Object)e);
        }
        return false;
    }

    public void addListener(LeadershipEventListener listener) {
        this.listenerRegistry.addListener((EventListener)listener);
    }

    public void removeListener(LeadershipEventListener listener) {
        this.listenerRegistry.removeListener((EventListener)listener);
    }

    public boolean makeTopCandidate(String path, NodeId nodeId) {
        Versioned newCandidates = this.candidateMap.computeIf((Object)path, candidates -> candidates != null && candidates.contains(nodeId) && !nodeId.equals(Iterables.getFirst((Iterable)candidates, null)), (topic, candidates) -> {
            ArrayList<NodeId> updatedCandidates = new ArrayList<NodeId>(candidates.size());
            updatedCandidates.add(nodeId);
            candidates.stream().filter(id -> !nodeId.equals(id)).forEach(updatedCandidates::add);
            return updatedCandidates;
        });
        this.publish(new LeadershipEvent(LeadershipEvent.Type.CANDIDATES_CHANGED, new Leadership(path, (List)newCandidates.value(), newCandidates.version(), newCandidates.creationTime())));
        return true;
    }

    private Leadership electLeader(String path, List<NodeId> candidates) {
        Leadership currentLeadership = this.getLeadership(path);
        if (currentLeadership != null) {
            return currentLeadership;
        }
        NodeId topCandidate = candidates.stream().filter(n -> this.clusterService.getState(n) == ControllerNode.State.ACTIVE).findFirst().orElse(null);
        try {
            Versioned leader;
            Versioned versioned = leader = this.localNodeId.equals((Object)topCandidate) ? this.leaderMap.computeIfAbsent((Object)path, p -> this.localNodeId) : this.leaderMap.get((Object)path);
            if (leader != null) {
                Leadership newLeadership = new Leadership(path, (NodeId)leader.value(), leader.version(), leader.creationTime());
                this.publish(new LeadershipEvent(LeadershipEvent.Type.LEADER_ELECTED, newLeadership));
                return newLeadership;
            }
        }
        catch (Exception e) {
            this.log.debug("Failed to elect leader for {}", (Object)path, (Object)e);
        }
        return null;
    }

    private void electLeaders() {
        try {
            this.candidateMap.entrySet().forEach(entry -> {
                String path = (String)entry.getKey();
                Versioned candidates = (Versioned)entry.getValue();
                if (this.activeTopics.contains(path)) {
                    this.lockExecutor.submit(() -> {
                        CompletableFuture<Leadership> future;
                        Leadership leadership = this.electLeader(path, (List)candidates.value());
                        if (leadership != null && (future = this.pendingFutures.remove(path)) != null) {
                            future.complete(leadership);
                        }
                    });
                }
                this.onLeadershipEvent(new LeadershipEvent(LeadershipEvent.Type.CANDIDATES_CHANGED, new Leadership(path, (List)candidates.value(), candidates.version(), candidates.creationTime())));
            });
        }
        catch (Exception e) {
            this.log.debug("Failure electing leaders", (Throwable)e);
        }
    }

    private void publish(LeadershipEvent event) {
        this.onLeadershipEvent(event);
        this.clusterCommunicator.broadcast((Object)event, LEADERSHIP_EVENT_MESSAGE_SUBJECT, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0));
    }

    private void onLeadershipEvent(LeadershipEvent leadershipEvent) {
        this.log.trace("Leadership Event: time = {} type = {} event = {}", new Object[]{leadershipEvent.time(), leadershipEvent.type(), leadershipEvent});
        Leadership leadershipUpdate = (Leadership)leadershipEvent.subject();
        LeadershipEvent.Type eventType = (LeadershipEvent.Type)leadershipEvent.type();
        String topic = leadershipUpdate.topic();
        AtomicBoolean updateAccepted = new AtomicBoolean(false);
        if (eventType.equals((Object)LeadershipEvent.Type.LEADER_ELECTED)) {
            this.leaderBoard.compute(topic, (k, currentLeadership) -> {
                if (currentLeadership == null || currentLeadership.epoch() < leadershipUpdate.epoch()) {
                    updateAccepted.set(true);
                    return leadershipUpdate;
                }
                return currentLeadership;
            });
        } else if (eventType.equals((Object)LeadershipEvent.Type.LEADER_BOOTED)) {
            this.leaderBoard.compute(topic, (k, currentLeadership) -> {
                if (currentLeadership == null || currentLeadership.epoch() <= leadershipUpdate.epoch()) {
                    updateAccepted.set(true);
                    return null;
                }
                return currentLeadership;
            });
        } else if (eventType.equals((Object)LeadershipEvent.Type.CANDIDATES_CHANGED)) {
            this.candidateBoard.compute(topic, (k, currentInfo) -> {
                if (currentInfo == null || currentInfo.epoch() < leadershipUpdate.epoch()) {
                    updateAccepted.set(true);
                    return leadershipUpdate;
                }
                return currentInfo;
            });
        } else {
            throw new IllegalStateException("Unknown event type.");
        }
        if (updateAccepted.get()) {
            this.eventDispatcher.post((Event)leadershipEvent);
        }
    }

    private void rerunForLeadership(String path, CompletableFuture<Leadership> future) {
        this.lockExecutor.schedule(() -> this.doRunForLeadership(path, future), (long)RandomUtils.nextInt((int)150), TimeUnit.MILLISECONDS);
    }

    private void retryWithdraw(String path, CompletableFuture<Void> future) {
        this.lockExecutor.schedule(() -> this.doWithdraw(path, future), (long)RandomUtils.nextInt((int)150), TimeUnit.MILLISECONDS);
    }

    private void scheduleStaleLeadershipPurge(int afterDelaySec) {
        if (this.staleLeadershipPurgeScheduled.compareAndSet(false, true)) {
            this.staleLeadershipPurgeExecutor.schedule(this::purgeStaleLeadership, (long)afterDelaySec, TimeUnit.SECONDS);
        }
    }

    private void purgeStaleLeadership() {
        AtomicBoolean rerunPurge = new AtomicBoolean(false);
        try {
            this.staleLeadershipPurgeScheduled.set(false);
            this.leaderMap.entrySet().stream().filter(e -> this.clusterService.getState((NodeId)((Versioned)e.getValue()).value()) == ControllerNode.State.INACTIVE).forEach(entry -> {
                String path = (String)entry.getKey();
                NodeId nodeId = (NodeId)((Versioned)entry.getValue()).value();
                long epoch = ((Versioned)entry.getValue()).version();
                long creationTime = ((Versioned)entry.getValue()).creationTime();
                try {
                    if (this.leaderMap.remove((Object)path, epoch)) {
                        this.log.debug("Purged stale lock held by {} for {}", (Object)nodeId, (Object)path);
                        this.publish(new LeadershipEvent(LeadershipEvent.Type.LEADER_BOOTED, new Leadership(path, nodeId, epoch, creationTime)));
                    }
                }
                catch (Exception e) {
                    this.log.debug("Failed to purge stale lock held by {} for {}", new Object[]{nodeId, path, e});
                    rerunPurge.set(true);
                }
            });
            this.candidateMap.entrySet().forEach(entry -> {
                String path = (String)entry.getKey();
                Versioned candidates = (Versioned)entry.getValue();
                List candidatesList = candidates != null ? (List)candidates.value() : Collections.emptyList();
                List activeCandidatesList = candidatesList.stream().filter(n -> this.clusterService.getState(n) == ControllerNode.State.ACTIVE).filter(n -> !this.localNodeId.equals(n) || this.activeTopics.contains(path)).collect(Collectors.toList());
                if (activeCandidatesList.size() < candidatesList.size()) {
                    Sets.SetView removedCandidates = Sets.difference((Set)Sets.newHashSet((Iterable)candidatesList), (Set)Sets.newHashSet(activeCandidatesList));
                    try {
                        if (this.candidateMap.replace((Object)path, ((Versioned)entry.getValue()).version(), activeCandidatesList)) {
                            this.log.info("Evicted inactive candidates {} from candidate list for {}", (Object)removedCandidates, (Object)path);
                            Versioned updatedCandidates = this.candidateMap.get((Object)path);
                            this.publish(new LeadershipEvent(LeadershipEvent.Type.CANDIDATES_CHANGED, new Leadership(path, (List)updatedCandidates.value(), updatedCandidates.version(), updatedCandidates.creationTime())));
                        } else {
                            rerunPurge.set(true);
                        }
                    }
                    catch (Exception e) {
                        this.log.debug("Failed to evict inactive candidates {} from candidate list for {}", new Object[]{removedCandidates, path, e});
                        rerunPurge.set(true);
                    }
                }
            });
        }
        catch (Exception e2) {
            this.log.debug("Failure purging state leadership.", (Throwable)e2);
            rerunPurge.set(true);
        }
        if (rerunPurge.get()) {
            this.log.debug("Rescheduling stale leadership purge due to errors encountered in previous run");
            this.scheduleStaleLeadershipPurge(2);
        }
    }

    private void refreshLeaderBoard() {
        try {
            HashMap newLeaderBoard = Maps.newHashMap();
            this.leaderMap.entrySet().forEach(entry -> {
                String path = (String)entry.getKey();
                Versioned leader = (Versioned)entry.getValue();
                Leadership leadership = new Leadership(path, (NodeId)leader.value(), leader.version(), leader.creationTime());
                newLeaderBoard.put(path, leadership);
            });
            ImmutableMap currentLeaderBoard = ImmutableMap.copyOf(this.leaderBoard);
            MapDifference diff = Maps.difference((Map)currentLeaderBoard, (Map)newLeaderBoard);
            diff.entriesOnlyOnLeft().forEach((path, leadership) -> {
                this.log.debug("Evicting {} from leaderboard. It is no longer active leader.", leadership);
                this.onLeadershipEvent(new LeadershipEvent(LeadershipEvent.Type.LEADER_BOOTED, leadership));
            });
            diff.entriesOnlyOnRight().forEach((path, leadership) -> {
                this.log.debug("Adding {} to leaderboard. It is now the active leader.", leadership);
                this.onLeadershipEvent(new LeadershipEvent(LeadershipEvent.Type.LEADER_ELECTED, leadership));
            });
            diff.entriesDiffering().forEach((path, difference) -> {
                Leadership current = (Leadership)difference.leftValue();
                Leadership updated = (Leadership)difference.rightValue();
                if (current.epoch() < updated.epoch()) {
                    this.log.debug("Updated {} in leaderboard.", (Object)updated);
                    this.onLeadershipEvent(new LeadershipEvent(LeadershipEvent.Type.LEADER_ELECTED, updated));
                }
            });
        }
        catch (Exception e) {
            this.log.debug("Failed to refresh leader board", (Throwable)e);
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindEventDispatcher(EventDeliveryService eventDeliveryService) {
        this.eventDispatcher = eventDeliveryService;
    }

    protected void unbindEventDispatcher(EventDeliveryService eventDeliveryService) {
        if (this.eventDispatcher == eventDeliveryService) {
            this.eventDispatcher = null;
        }
    }

    private class InternalClusterEventListener
    implements ClusterEventListener {
        private InternalClusterEventListener() {
        }

        public void event(ClusterEvent event) {
            if (event.type() == ClusterEvent.Type.INSTANCE_DEACTIVATED || event.type() == ClusterEvent.Type.INSTANCE_REMOVED) {
                DistributedLeadershipManager.this.scheduleStaleLeadershipPurge(0);
            }
        }
    }
}

