/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.impl;

import com.google.common.testing.EqualsTester;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.util.KryoNamespace;
import org.onosproject.store.Timestamp;
import org.onosproject.store.service.WallClockTimestamp;

public class WallClockTimestampTest {
    @Test
    public final void testBasic() throws InterruptedException {
        WallClockTimestamp ts1 = new WallClockTimestamp();
        Thread.sleep(50L);
        WallClockTimestamp ts2 = new WallClockTimestamp();
        Assert.assertTrue((ts1.compareTo((Timestamp)ts1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((ts2.compareTo((Timestamp)ts1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((ts1.compareTo((Timestamp)ts2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public final void testKryoSerializable() {
        WallClockTimestamp ts1 = new WallClockTimestamp();
        ByteBuffer buffer = ByteBuffer.allocate(0x100000);
        KryoNamespace kryos = KryoNamespace.newBuilder().register(new Class[]{WallClockTimestamp.class}).build();
        kryos.serialize((Object)ts1, buffer);
        buffer.flip();
        Timestamp copy = (Timestamp)kryos.deserialize(buffer);
        new EqualsTester().addEqualityGroup(new Object[]{ts1, copy}).testEquals();
    }
}

