/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.link.impl;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.mastership.MastershipServiceAdapter;
import org.onosproject.mastership.MastershipTerm;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DeviceClockService;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkStore;
import org.onosproject.net.link.LinkStoreDelegate;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.cluster.StaticClusterService;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessageHandler;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.device.impl.DeviceClockManager;
import org.onosproject.store.link.impl.GossipLinkStore;
import org.onosproject.store.link.impl.GossipLinkStoreMessageSubjects;
import org.onosproject.store.link.impl.InternalLinkEvent;

public class GossipLinkStoreTest {
    private static final ProviderId PID = new ProviderId("of", "foo");
    private static final ProviderId PIDA = new ProviderId("of", "bar", true);
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:foo");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"of:bar");
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final PortNumber P2 = PortNumber.portNumber((long)2L);
    private static final PortNumber P3 = PortNumber.portNumber((long)3L);
    private static final SparseAnnotations A1 = DefaultAnnotations.builder().set("A1", "a1").set("B1", "b1").build();
    private static final SparseAnnotations A1_2 = DefaultAnnotations.builder().remove("A1").set("B3", "b3").build();
    private static final SparseAnnotations A2 = DefaultAnnotations.builder().set("A2", "a2").set("B2", "b2").build();
    private static final SparseAnnotations A2_2 = DefaultAnnotations.builder().remove("A2").set("B4", "b4").build();
    private static final NodeId NID1 = new NodeId("local");
    private static final ControllerNode ONOS1 = new DefaultControllerNode(NID1, IpAddress.valueOf((String)"127.0.0.1"));
    private static final NodeId NID2 = new NodeId("remote");
    private static final ControllerNode ONOS2 = new DefaultControllerNode(NID2, IpAddress.valueOf((String)"127.0.0.2"));
    private GossipLinkStore linkStoreImpl;
    private LinkStore linkStore;
    private DeviceClockManager deviceClockManager;
    private DeviceClockService deviceClockService;
    private ClusterCommunicationService clusterCommunicator;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.deviceClockManager = new DeviceClockManager();
        this.deviceClockManager.activate();
        this.deviceClockService = this.deviceClockManager;
        this.deviceClockManager.setMastershipTerm(DID1, MastershipTerm.of((NodeId)NID1, (long)1L));
        this.deviceClockManager.setMastershipTerm(DID2, MastershipTerm.of((NodeId)NID1, (long)2L));
        this.clusterCommunicator = (ClusterCommunicationService)EasyMock.createNiceMock(ClusterCommunicationService.class);
        this.clusterCommunicator.addSubscriber((MessageSubject)EasyMock.anyObject(MessageSubject.class), (ClusterMessageHandler)EasyMock.anyObject(ClusterMessageHandler.class), (ExecutorService)EasyMock.anyObject(ExecutorService.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
        this.linkStoreImpl = new GossipLinkStore();
        this.linkStoreImpl.deviceClockService = this.deviceClockService;
        this.linkStoreImpl.clusterCommunicator = this.clusterCommunicator;
        this.linkStoreImpl.clusterService = new TestClusterService();
        this.linkStoreImpl.mastershipService = new TestMastershipService();
        this.linkStoreImpl.activate();
        this.linkStore = this.linkStoreImpl;
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
    }

    @After
    public void tearDown() throws Exception {
        this.linkStoreImpl.deactivate();
    }

    private void putLink(DeviceId srcId, PortNumber srcNum, DeviceId dstId, PortNumber dstNum, Link.Type type, SparseAnnotations ... annotations) {
        ConnectPoint src = new ConnectPoint((ElementId)srcId, srcNum);
        ConnectPoint dst = new ConnectPoint((ElementId)dstId, dstNum);
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
        this.clusterCommunicator.broadcast(EasyMock.anyObject(InternalLinkEvent.class), (MessageSubject)EasyMock.anyObject(MessageSubject.class), (Function)EasyMock.anyObject(Function.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
        this.linkStore.createOrUpdateLink(PID, (LinkDescription)new DefaultLinkDescription(src, dst, type, annotations));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
    }

    private <T> void resetCommunicatorExpectingSingleBroadcast(Capture<T> message, Capture<MessageSubject> subject, Capture<Function<T, byte[]>> encoder) {
        message.reset();
        subject.reset();
        encoder.reset();
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
        this.clusterCommunicator.broadcast(EasyMock.capture(message), (MessageSubject)EasyMock.capture(subject), (Function)EasyMock.capture(encoder));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
    }

    private void putLink(LinkKey key, Link.Type type, SparseAnnotations ... annotations) {
        this.putLink(key.src().deviceId(), key.src().port(), key.dst().deviceId(), key.dst().port(), type, annotations);
    }

    private static void assertLink(DeviceId srcId, PortNumber srcNum, DeviceId dstId, PortNumber dstNum, Link.Type type, Link link) {
        Assert.assertEquals((Object)srcId, (Object)link.src().deviceId());
        Assert.assertEquals((Object)srcNum, (Object)link.src().port());
        Assert.assertEquals((Object)dstId, (Object)link.dst().deviceId());
        Assert.assertEquals((Object)dstNum, (Object)link.dst().port());
        Assert.assertEquals((Object)type, (Object)link.type());
    }

    private static void assertLink(LinkKey key, Link.Type type, Link link) {
        GossipLinkStoreTest.assertLink(key.src().deviceId(), key.src().port(), key.dst().deviceId(), key.dst().port(), type, link);
    }

    @Test
    public final void testGetLinkCount() {
        Assert.assertEquals((String)"initialy empty", (long)0L, (long)this.linkStore.getLinkCount());
        this.putLink(DID1, P1, DID2, P2, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(DID2, P2, DID1, P1, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(DID1, P1, DID2, P2, Link.Type.DIRECT, new SparseAnnotations[0]);
        Assert.assertEquals((String)"expecting 2 unique link", (long)2L, (long)this.linkStore.getLinkCount());
    }

    @Test
    public final void testGetLinks() {
        Assert.assertEquals((String)"initialy empty", (long)0L, (long)Iterables.size((Iterable)this.linkStore.getLinks()));
        LinkKey linkId1 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID1, P1), (ConnectPoint)new ConnectPoint((ElementId)DID2, P2));
        LinkKey linkId2 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID2, P2), (ConnectPoint)new ConnectPoint((ElementId)DID1, P1));
        this.putLink(linkId1, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId2, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId1, Link.Type.DIRECT, new SparseAnnotations[0]);
        Assert.assertEquals((String)"expecting 2 unique link", (long)2L, (long)Iterables.size((Iterable)this.linkStore.getLinks()));
        HashMap<LinkKey, Link> links = new HashMap<LinkKey, Link>();
        for (Link link : this.linkStore.getLinks()) {
            links.put(LinkKey.linkKey((Link)link), link);
        }
        GossipLinkStoreTest.assertLink(linkId1, Link.Type.DIRECT, (Link)links.get(linkId1));
        GossipLinkStoreTest.assertLink(linkId2, Link.Type.DIRECT, (Link)links.get(linkId2));
    }

    @Test
    public final void testGetDeviceEgressLinks() {
        LinkKey linkId1 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID1, P1), (ConnectPoint)new ConnectPoint((ElementId)DID2, P2));
        LinkKey linkId2 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID2, P2), (ConnectPoint)new ConnectPoint((ElementId)DID1, P1));
        LinkKey linkId3 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID1, P2), (ConnectPoint)new ConnectPoint((ElementId)DID2, P3));
        this.putLink(linkId1, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId2, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId3, Link.Type.DIRECT, new SparseAnnotations[0]);
        Set links1 = this.linkStore.getDeviceEgressLinks(DID1);
        Assert.assertEquals((long)2L, (long)links1.size());
        Set links2 = this.linkStore.getDeviceEgressLinks(DID2);
        Assert.assertEquals((long)1L, (long)links2.size());
        GossipLinkStoreTest.assertLink(linkId2, Link.Type.DIRECT, (Link)links2.iterator().next());
    }

    @Test
    public final void testGetDeviceIngressLinks() {
        LinkKey linkId1 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID1, P1), (ConnectPoint)new ConnectPoint((ElementId)DID2, P2));
        LinkKey linkId2 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID2, P2), (ConnectPoint)new ConnectPoint((ElementId)DID1, P1));
        LinkKey linkId3 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID1, P2), (ConnectPoint)new ConnectPoint((ElementId)DID2, P3));
        this.putLink(linkId1, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId2, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId3, Link.Type.DIRECT, new SparseAnnotations[0]);
        Set links1 = this.linkStore.getDeviceIngressLinks(DID2);
        Assert.assertEquals((long)2L, (long)links1.size());
        Set links2 = this.linkStore.getDeviceIngressLinks(DID1);
        Assert.assertEquals((long)1L, (long)links2.size());
        GossipLinkStoreTest.assertLink(linkId2, Link.Type.DIRECT, (Link)links2.iterator().next());
    }

    @Test
    public final void testGetLink() {
        ConnectPoint src = new ConnectPoint((ElementId)DID1, P1);
        ConnectPoint dst = new ConnectPoint((ElementId)DID2, P2);
        LinkKey linkId1 = LinkKey.linkKey((ConnectPoint)src, (ConnectPoint)dst);
        this.putLink(linkId1, Link.Type.DIRECT, new SparseAnnotations[0]);
        Link link = this.linkStore.getLink(src, dst);
        GossipLinkStoreTest.assertLink(linkId1, Link.Type.DIRECT, link);
        Assert.assertNull((String)"There shouldn't be reverese link", (Object)this.linkStore.getLink(dst, src));
    }

    @Test
    public final void testGetEgressLinks() {
        ConnectPoint d1P1 = new ConnectPoint((ElementId)DID1, P1);
        ConnectPoint d2P2 = new ConnectPoint((ElementId)DID2, P2);
        LinkKey linkId1 = LinkKey.linkKey((ConnectPoint)d1P1, (ConnectPoint)d2P2);
        LinkKey linkId2 = LinkKey.linkKey((ConnectPoint)d2P2, (ConnectPoint)d1P1);
        LinkKey linkId3 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID1, P2), (ConnectPoint)new ConnectPoint((ElementId)DID2, P3));
        this.putLink(linkId1, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId2, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId3, Link.Type.DIRECT, new SparseAnnotations[0]);
        Set links1 = this.linkStore.getEgressLinks(d1P1);
        Assert.assertEquals((long)1L, (long)links1.size());
        GossipLinkStoreTest.assertLink(linkId1, Link.Type.DIRECT, (Link)links1.iterator().next());
        Set links2 = this.linkStore.getEgressLinks(d2P2);
        Assert.assertEquals((long)1L, (long)links2.size());
        GossipLinkStoreTest.assertLink(linkId2, Link.Type.DIRECT, (Link)links2.iterator().next());
    }

    @Test
    public final void testGetIngressLinks() {
        ConnectPoint d1P1 = new ConnectPoint((ElementId)DID1, P1);
        ConnectPoint d2P2 = new ConnectPoint((ElementId)DID2, P2);
        LinkKey linkId1 = LinkKey.linkKey((ConnectPoint)d1P1, (ConnectPoint)d2P2);
        LinkKey linkId2 = LinkKey.linkKey((ConnectPoint)d2P2, (ConnectPoint)d1P1);
        LinkKey linkId3 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID1, P2), (ConnectPoint)new ConnectPoint((ElementId)DID2, P3));
        this.putLink(linkId1, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId2, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId3, Link.Type.DIRECT, new SparseAnnotations[0]);
        Set links1 = this.linkStore.getIngressLinks(d2P2);
        Assert.assertEquals((long)1L, (long)links1.size());
        GossipLinkStoreTest.assertLink(linkId1, Link.Type.DIRECT, (Link)links1.iterator().next());
        Set links2 = this.linkStore.getIngressLinks(d1P1);
        Assert.assertEquals((long)1L, (long)links2.size());
        GossipLinkStoreTest.assertLink(linkId2, Link.Type.DIRECT, (Link)links2.iterator().next());
    }

    @Test
    public final void testCreateOrUpdateLink() {
        ConnectPoint src = new ConnectPoint((ElementId)DID1, P1);
        ConnectPoint dst = new ConnectPoint((ElementId)DID2, P2);
        Capture message = new Capture();
        Capture subject = new Capture();
        Capture encoder = new Capture();
        this.resetCommunicatorExpectingSingleBroadcast(message, (Capture<MessageSubject>)subject, encoder);
        DefaultLinkDescription linkDescription = new DefaultLinkDescription(src, dst, Link.Type.INDIRECT, new SparseAnnotations[0]);
        LinkEvent event = this.linkStore.createOrUpdateLink(PID, (LinkDescription)linkDescription);
        this.verifyLinkBroadcastMessage(PID, NID1, src, dst, Link.Type.INDIRECT, (Capture<InternalLinkEvent>)message, (Capture<MessageSubject>)subject, (Capture<Function<InternalLinkEvent, byte[]>>)encoder);
        GossipLinkStoreTest.assertLink(DID1, P1, DID2, P2, Link.Type.INDIRECT, (Link)event.subject());
        Assert.assertEquals((Object)LinkEvent.Type.LINK_ADDED, (Object)event.type());
        this.resetCommunicatorExpectingSingleBroadcast(message, (Capture<MessageSubject>)subject, encoder);
        LinkEvent event2 = this.linkStore.createOrUpdateLink(PID, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.DIRECT, new SparseAnnotations[0]));
        this.verifyLinkBroadcastMessage(PID, NID1, src, dst, Link.Type.DIRECT, (Capture<InternalLinkEvent>)message, (Capture<MessageSubject>)subject, (Capture<Function<InternalLinkEvent, byte[]>>)encoder);
        GossipLinkStoreTest.assertLink(DID1, P1, DID2, P2, Link.Type.DIRECT, (Link)event2.subject());
        Assert.assertEquals((Object)LinkEvent.Type.LINK_UPDATED, (Object)event2.type());
        this.resetCommunicatorExpectingSingleBroadcast(message, (Capture<MessageSubject>)subject, encoder);
        LinkEvent event3 = this.linkStore.createOrUpdateLink(PID, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.DIRECT, new SparseAnnotations[0]));
        this.verifyNoBroadcastMessage(message);
        Assert.assertNull((String)"No change event expected", (Object)event3);
    }

    private <T> void verifyNoBroadcastMessage(Capture<T> message) {
        Assert.assertFalse((String)"No broadcast expected", (boolean)message.hasCaptured());
    }

    private void verifyLinkBroadcastMessage(ProviderId providerId, NodeId sender, ConnectPoint src, ConnectPoint dst, Link.Type type, Capture<InternalLinkEvent> actualLinkEvent, Capture<MessageSubject> actualSubject, Capture<Function<InternalLinkEvent, byte[]>> actualEncoder) {
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        Assert.assertTrue((boolean)actualLinkEvent.hasCaptured());
        Assert.assertEquals((Object)GossipLinkStoreMessageSubjects.LINK_UPDATE, (Object)actualSubject.getValue());
        Assert.assertEquals((Object)providerId, (Object)((InternalLinkEvent)actualLinkEvent.getValue()).providerId());
        GossipLinkStoreTest.assertLinkDescriptionEquals(src, dst, type, (LinkDescription)((InternalLinkEvent)actualLinkEvent.getValue()).linkDescription().value());
    }

    private static void assertLinkDescriptionEquals(ConnectPoint src, ConnectPoint dst, Link.Type type, LinkDescription actual) {
        Assert.assertEquals((Object)src, (Object)actual.src());
        Assert.assertEquals((Object)dst, (Object)actual.dst());
        Assert.assertEquals((Object)type, (Object)actual.type());
    }

    @Test
    public final void testCreateOrUpdateLinkAncillary() {
        ConnectPoint src = new ConnectPoint((ElementId)DID1, P1);
        ConnectPoint dst = new ConnectPoint((ElementId)DID2, P2);
        Capture message = new Capture();
        Capture subject = new Capture();
        Capture encoder = new Capture();
        this.resetCommunicatorExpectingSingleBroadcast(message, (Capture<MessageSubject>)subject, encoder);
        LinkEvent event = this.linkStore.createOrUpdateLink(PIDA, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.INDIRECT, new SparseAnnotations[]{A1}));
        this.verifyLinkBroadcastMessage(PIDA, NID1, src, dst, Link.Type.INDIRECT, (Capture<InternalLinkEvent>)message, (Capture<MessageSubject>)subject, (Capture<Function<InternalLinkEvent, byte[]>>)encoder);
        Assert.assertNotNull((String)"Ancillary only link is ignored", (Object)event);
        this.resetCommunicatorExpectingSingleBroadcast(message, (Capture<MessageSubject>)subject, encoder);
        LinkEvent event2 = this.linkStore.createOrUpdateLink(PID, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.INDIRECT, new SparseAnnotations[]{A2}));
        this.verifyLinkBroadcastMessage(PID, NID1, src, dst, Link.Type.INDIRECT, (Capture<InternalLinkEvent>)message, (Capture<MessageSubject>)subject, (Capture<Function<InternalLinkEvent, byte[]>>)encoder);
        GossipLinkStoreTest.assertLink(DID1, P1, DID2, P2, Link.Type.INDIRECT, (Link)event2.subject());
        NetTestTools.assertAnnotationsEquals((Annotations)((Link)event2.subject()).annotations(), (SparseAnnotations[])new SparseAnnotations[]{A2, A1});
        Assert.assertEquals((Object)LinkEvent.Type.LINK_UPDATED, (Object)event2.type());
        this.resetCommunicatorExpectingSingleBroadcast(message, (Capture<MessageSubject>)subject, encoder);
        LinkEvent event3 = this.linkStore.createOrUpdateLink(PID, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.DIRECT, new SparseAnnotations[]{A2}));
        this.verifyLinkBroadcastMessage(PID, NID1, src, dst, Link.Type.DIRECT, (Capture<InternalLinkEvent>)message, (Capture<MessageSubject>)subject, (Capture<Function<InternalLinkEvent, byte[]>>)encoder);
        GossipLinkStoreTest.assertLink(DID1, P1, DID2, P2, Link.Type.DIRECT, (Link)event3.subject());
        NetTestTools.assertAnnotationsEquals((Annotations)((Link)event3.subject()).annotations(), (SparseAnnotations[])new SparseAnnotations[]{A2, A1});
        Assert.assertEquals((Object)LinkEvent.Type.LINK_UPDATED, (Object)event3.type());
        this.resetCommunicatorExpectingSingleBroadcast(message, (Capture<MessageSubject>)subject, encoder);
        LinkEvent event4 = this.linkStore.createOrUpdateLink(PID, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.DIRECT, new SparseAnnotations[0]));
        this.verifyNoBroadcastMessage(message);
        Assert.assertNull((String)"No change event expected", (Object)event4);
        this.resetCommunicatorExpectingSingleBroadcast(message, (Capture<MessageSubject>)subject, encoder);
        LinkEvent event5 = this.linkStore.createOrUpdateLink(PID, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.DIRECT, new SparseAnnotations[]{A2_2}));
        this.verifyLinkBroadcastMessage(PID, NID1, src, dst, Link.Type.DIRECT, (Capture<InternalLinkEvent>)message, (Capture<MessageSubject>)subject, (Capture<Function<InternalLinkEvent, byte[]>>)encoder);
        GossipLinkStoreTest.assertLink(DID1, P1, DID2, P2, Link.Type.DIRECT, (Link)event5.subject());
        NetTestTools.assertAnnotationsEquals((Annotations)((Link)event5.subject()).annotations(), (SparseAnnotations[])new SparseAnnotations[]{A2, A2_2, A1});
        Assert.assertEquals((Object)LinkEvent.Type.LINK_UPDATED, (Object)event5.type());
        this.resetCommunicatorExpectingSingleBroadcast(message, (Capture<MessageSubject>)subject, encoder);
        LinkEvent event6 = this.linkStore.createOrUpdateLink(PIDA, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.DIRECT, new SparseAnnotations[]{A1_2}));
        this.verifyLinkBroadcastMessage(PIDA, NID1, src, dst, Link.Type.DIRECT, (Capture<InternalLinkEvent>)message, (Capture<MessageSubject>)subject, (Capture<Function<InternalLinkEvent, byte[]>>)encoder);
        GossipLinkStoreTest.assertLink(DID1, P1, DID2, P2, Link.Type.DIRECT, (Link)event6.subject());
        NetTestTools.assertAnnotationsEquals((Annotations)((Link)event6.subject()).annotations(), (SparseAnnotations[])new SparseAnnotations[]{A2, A2_2, A1, A1_2});
        Assert.assertEquals((Object)LinkEvent.Type.LINK_UPDATED, (Object)event6.type());
        this.resetCommunicatorExpectingSingleBroadcast(message, (Capture<MessageSubject>)subject, encoder);
        LinkEvent event7 = this.linkStore.createOrUpdateLink(PIDA, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.EDGE, new SparseAnnotations[0]));
        this.verifyNoBroadcastMessage(message);
        Assert.assertNull((String)"Ancillary change other than annotation is ignored", (Object)event7);
    }

    @Test
    public final void testRemoveLink() {
        ConnectPoint d1P1 = new ConnectPoint((ElementId)DID1, P1);
        ConnectPoint d2P2 = new ConnectPoint((ElementId)DID2, P2);
        LinkKey linkId1 = LinkKey.linkKey((ConnectPoint)d1P1, (ConnectPoint)d2P2);
        LinkKey linkId2 = LinkKey.linkKey((ConnectPoint)d2P2, (ConnectPoint)d1P1);
        this.putLink(linkId1, Link.Type.DIRECT, A1);
        this.putLink(linkId2, Link.Type.DIRECT, A2);
        LinkEvent event = this.linkStore.removeLink(d1P1, d2P2);
        Assert.assertEquals((Object)LinkEvent.Type.LINK_REMOVED, (Object)event.type());
        NetTestTools.assertAnnotationsEquals((Annotations)((Link)event.subject()).annotations(), (SparseAnnotations[])new SparseAnnotations[]{A1});
        LinkEvent event2 = this.linkStore.removeLink(d1P1, d2P2);
        Assert.assertNull((Object)event2);
        GossipLinkStoreTest.assertLink(linkId2, Link.Type.DIRECT, this.linkStore.getLink(d2P2, d1P1));
        NetTestTools.assertAnnotationsEquals((Annotations)this.linkStore.getLink(d2P2, d1P1).annotations(), (SparseAnnotations[])new SparseAnnotations[]{A2});
        this.putLink(linkId1, Link.Type.DIRECT, new SparseAnnotations[0]);
        GossipLinkStoreTest.assertLink(linkId1, Link.Type.DIRECT, this.linkStore.getLink(d1P1, d2P2));
        NetTestTools.assertAnnotationsEquals((Annotations)this.linkStore.getLink(d1P1, d2P2).annotations(), (SparseAnnotations[])new SparseAnnotations[0]);
    }

    @Test
    public final void testAncillaryVisible() {
        ConnectPoint src = new ConnectPoint((ElementId)DID1, P1);
        ConnectPoint dst = new ConnectPoint((ElementId)DID2, P2);
        this.linkStore.createOrUpdateLink(PIDA, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.INDIRECT, new SparseAnnotations[]{A1}));
        Assert.assertEquals((long)1L, (long)this.linkStore.getLinkCount());
        Assert.assertNotNull((Object)this.linkStore.getLink(src, dst));
    }

    @Ignore(value="Ignore until Delegate spec. is clear.")
    @Test
    public final void testEvents() throws InterruptedException {
        ConnectPoint d1P1 = new ConnectPoint((ElementId)DID1, P1);
        ConnectPoint d2P2 = new ConnectPoint((ElementId)DID2, P2);
        final LinkKey linkId1 = LinkKey.linkKey((ConnectPoint)d1P1, (ConnectPoint)d2P2);
        final CountDownLatch addLatch = new CountDownLatch(1);
        LinkStoreDelegate checkAdd = new LinkStoreDelegate(){

            public void notify(LinkEvent event) {
                Assert.assertEquals((Object)LinkEvent.Type.LINK_ADDED, (Object)event.type());
                GossipLinkStoreTest.assertLink(linkId1, Link.Type.INDIRECT, (Link)event.subject());
                addLatch.countDown();
            }
        };
        final CountDownLatch updateLatch = new CountDownLatch(1);
        LinkStoreDelegate checkUpdate = new LinkStoreDelegate(){

            public void notify(LinkEvent event) {
                Assert.assertEquals((Object)LinkEvent.Type.LINK_UPDATED, (Object)event.type());
                GossipLinkStoreTest.assertLink(linkId1, Link.Type.DIRECT, (Link)event.subject());
                updateLatch.countDown();
            }
        };
        final CountDownLatch removeLatch = new CountDownLatch(1);
        LinkStoreDelegate checkRemove = new LinkStoreDelegate(){

            public void notify(LinkEvent event) {
                Assert.assertEquals((Object)LinkEvent.Type.LINK_REMOVED, (Object)event.type());
                GossipLinkStoreTest.assertLink(linkId1, Link.Type.DIRECT, (Link)event.subject());
                removeLatch.countDown();
            }
        };
        this.linkStore.setDelegate((StoreDelegate)checkAdd);
        this.putLink(linkId1, Link.Type.INDIRECT, new SparseAnnotations[0]);
        Assert.assertTrue((String)"Add event fired", (boolean)addLatch.await(1L, TimeUnit.SECONDS));
        this.linkStore.unsetDelegate((StoreDelegate)checkAdd);
        this.linkStore.setDelegate((StoreDelegate)checkUpdate);
        this.putLink(linkId1, Link.Type.DIRECT, new SparseAnnotations[0]);
        Assert.assertTrue((String)"Update event fired", (boolean)updateLatch.await(1L, TimeUnit.SECONDS));
        this.linkStore.unsetDelegate((StoreDelegate)checkUpdate);
        this.linkStore.setDelegate((StoreDelegate)checkRemove);
        this.linkStore.removeLink(d1P1, d2P2);
        Assert.assertTrue((String)"Remove event fired", (boolean)removeLatch.await(1L, TimeUnit.SECONDS));
    }

    private final class TestMastershipService
    extends MastershipServiceAdapter {
        private TestMastershipService() {
        }

        public NodeId getMasterFor(DeviceId deviceId) {
            return NID1;
        }
    }

    private static final class TestClusterService
    extends StaticClusterService {
        public TestClusterService() {
            this.localNode = ONOS1;
            this.nodes.put(NID1, ONOS1);
            this.nodeStates.put(NID1, ControllerNode.State.ACTIVE);
            this.nodes.put(NID2, ONOS2);
            this.nodeStates.put(NID2, ControllerNode.State.ACTIVE);
        }
    }
}

