/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterDefinitionService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.store.cluster.impl.ClusterDefinition;
import org.onosproject.store.cluster.impl.ClusterDefinitionStore;
import org.onosproject.store.cluster.impl.NodeInfo;
import org.onosproject.store.consistent.impl.DatabaseDefinition;
import org.onosproject.store.consistent.impl.DatabaseDefinitionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class ClusterDefinitionManager
implements ClusterDefinitionService {
    public static final String CLUSTER_DEFINITION_FILE = "../config/cluster.json";
    private static final String ONOS_NIC = "ONOS_NIC";
    private static final Logger log = LoggerFactory.getLogger(ClusterDefinitionManager.class);
    private ControllerNode localNode;
    private Set<ControllerNode> seedNodes;

    @Activate
    public void activate() {
        File clusterDefinitionFile = new File(CLUSTER_DEFINITION_FILE);
        ClusterDefinitionStore clusterDefinitionStore = new ClusterDefinitionStore(clusterDefinitionFile.getPath());
        if (!clusterDefinitionFile.exists()) {
            this.createDefaultClusterDefinition(clusterDefinitionStore);
        }
        try {
            ClusterDefinition clusterDefinition = clusterDefinitionStore.read();
            this.establishSelfIdentity(clusterDefinition);
            this.seedNodes = ImmutableSet.copyOf(clusterDefinition.getNodes()).stream().filter(n -> !this.localNode.id().equals((Object)new NodeId(n.getId()))).map(n -> new DefaultControllerNode(new NodeId(n.getId()), IpAddress.valueOf((String)n.getIp()), n.getTcpPort())).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read cluster definition.", e);
        }
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        log.info("Stopped");
    }

    public ControllerNode localNode() {
        return this.localNode;
    }

    public Set<ControllerNode> seedNodes() {
        return this.seedNodes;
    }

    public void formCluster(Set<ControllerNode> nodes, String ipPrefix) {
        try {
            HashSet infos = Sets.newHashSet();
            nodes.forEach(n -> infos.add(NodeInfo.from(n.id().toString(), n.ip().toString(), n.tcpPort())));
            ClusterDefinition cdef = ClusterDefinition.from(infos, ipPrefix);
            new ClusterDefinitionStore(CLUSTER_DEFINITION_FILE).write(cdef);
            DatabaseDefinition ddef = DatabaseDefinition.from(infos);
            new DatabaseDefinitionStore("../config/tablets.json").write(ddef);
        }
        catch (IOException e) {
            log.error("Unable to form cluster", (Throwable)e);
        }
    }

    private IpAddress findLocalIp(ClusterDefinition clusterDefinition) throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = iface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                IpAddress ip = IpAddress.valueOf((InetAddress)inetAddresses.nextElement());
                if (!ClusterDefinitionManager.matchInterface(ip.toString(), clusterDefinition.getIpPrefix())) continue;
                return ip;
            }
        }
        throw new IllegalStateException("Unable to determine local ip");
    }

    private void establishSelfIdentity(ClusterDefinition clusterDefinition) {
        try {
            IpAddress ip = this.findLocalIp(clusterDefinition);
            this.localNode = new DefaultControllerNode(new NodeId(ip.toString()), ip);
        }
        catch (SocketException e) {
            throw new IllegalStateException("Cannot determine local IP", e);
        }
    }

    private void createDefaultClusterDefinition(ClusterDefinitionStore store) {
        String ip = ClusterDefinitionManager.getSiteLocalAddress();
        String ipPrefix = ip.replaceFirst("\\.[0-9]*$", ".*");
        NodeInfo node = NodeInfo.from(ip, ip, 9876);
        try {
            store.write(ClusterDefinition.from((Set<NodeInfo>)ImmutableSet.of((Object)node), ipPrefix));
        }
        catch (IOException e) {
            log.warn("Unable to write default cluster definition", (Throwable)e);
        }
    }

    public static String getSiteLocalAddress() {
        try {
            String ipPrefix = System.getenv(ONOS_NIC);
            for (NetworkInterface nif : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InetAddress address : Collections.list(nif.getInetAddresses())) {
                    IpAddress ip = IpAddress.valueOf((InetAddress)address);
                    if ((ipPrefix != null || !address.isSiteLocalAddress()) && (ipPrefix == null || !ClusterDefinitionManager.matchInterface(ip.toString(), ipPrefix))) continue;
                    return ip.toString();
                }
            }
        }
        catch (SocketException e) {
            log.error("Unable to get network interfaces", (Throwable)e);
        }
        return IpAddress.valueOf((InetAddress)InetAddress.getLoopbackAddress()).toString();
    }

    private static boolean matchInterface(String ip, String ipPrefix) {
        String s = ipPrefix.replaceAll("\\.\\*", "");
        return ip.startsWith(s);
    }
}

