/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import net.kuujo.copycat.state.Initializer;
import net.kuujo.copycat.state.StateContext;
import org.apache.commons.lang3.tuple.Pair;
import org.onosproject.cluster.NodeId;
import org.onosproject.store.consistent.impl.DatabaseState;
import org.onosproject.store.consistent.impl.Result;
import org.onosproject.store.consistent.impl.UpdateResult;
import org.onosproject.store.service.DatabaseUpdate;
import org.onosproject.store.service.Transaction;
import org.onosproject.store.service.Versioned;

public class DefaultDatabaseState
implements DatabaseState<String, byte[]> {
    private Long nextVersion;
    private Map<String, AtomicLong> counters;
    private Map<String, Map<String, Versioned<byte[]>>> tables;
    private Map<String, Queue<byte[]>> queues;
    private Map<String, Set<NodeId>> queueUpdateNotificationTargets;
    private Map<String, Map<String, Update>> locks;

    @Override
    @Initializer
    public void init(StateContext<DatabaseState<String, byte[]>> context) {
        this.counters = (Map)context.get("counters");
        if (this.counters == null) {
            this.counters = Maps.newConcurrentMap();
            context.put("counters", this.counters);
        }
        this.tables = (Map)context.get("tables");
        if (this.tables == null) {
            this.tables = Maps.newConcurrentMap();
            context.put("tables", this.tables);
        }
        this.locks = (Map)context.get("locks");
        if (this.locks == null) {
            this.locks = Maps.newConcurrentMap();
            context.put("locks", this.locks);
        }
        this.queues = (Map)context.get("queues");
        if (this.queues == null) {
            this.queues = Maps.newConcurrentMap();
            context.put("queues", this.queues);
        }
        this.queueUpdateNotificationTargets = (Map)context.get("queueUpdateNotificationTargets");
        if (this.queueUpdateNotificationTargets == null) {
            this.queueUpdateNotificationTargets = Maps.newConcurrentMap();
            context.put("queueUpdateNotificationTargets", this.queueUpdateNotificationTargets);
        }
        this.nextVersion = (Long)context.get("nextVersion");
        if (this.nextVersion == null) {
            this.nextVersion = new Long(0L);
            context.put("nextVersion", (Object)this.nextVersion);
        }
    }

    @Override
    public Set<String> tableNames() {
        return new HashSet<String>(this.tables.keySet());
    }

    @Override
    public Map<String, Long> counters() {
        HashMap counterMap = Maps.newHashMap();
        this.counters.forEach((k, v) -> counterMap.put(k, v.get()));
        return counterMap;
    }

    @Override
    public int size(String tableName) {
        return this.getTableMap(tableName).size();
    }

    @Override
    public boolean isEmpty(String tableName) {
        return this.getTableMap(tableName).isEmpty();
    }

    @Override
    public boolean containsKey(String tableName, String key) {
        return this.getTableMap(tableName).containsKey(key);
    }

    @Override
    public boolean containsValue(String tableName, byte[] value) {
        return this.getTableMap(tableName).values().stream().anyMatch(v -> Arrays.equals((byte[])v.value(), value));
    }

    @Override
    public Versioned<byte[]> get(String tableName, String key) {
        return this.getTableMap(tableName).get(key);
    }

    @Override
    public Result<Versioned<byte[]>> put(String tableName, String key, byte[] value) {
        Result<Versioned<byte[]>> result;
        if (this.isLockedForUpdates(tableName, key)) {
            result = Result.locked();
        } else {
            this.nextVersion = this.nextVersion + 1L;
            result = Result.ok(this.getTableMap(tableName).put(key, (Versioned<byte[]>)new Versioned((Object)value, this.nextVersion.longValue())));
        }
        return result;
    }

    @Override
    public Result<UpdateResult<Versioned<byte[]>>> putAndGet(String tableName, String key, byte[] value) {
        if (this.isLockedForUpdates(tableName, key)) {
            return Result.locked();
        }
        this.nextVersion = this.nextVersion + 1L;
        Versioned newValue = new Versioned((Object)value, this.nextVersion.longValue());
        Versioned<byte[]> oldValue = this.getTableMap(tableName).put(key, (Versioned<byte[]>)newValue);
        return Result.ok(new UpdateResult<Versioned>(true, oldValue, newValue));
    }

    @Override
    public Result<UpdateResult<Versioned<byte[]>>> putIfAbsentAndGet(String tableName, String key, byte[] value) {
        if (this.isLockedForUpdates(tableName, key)) {
            return Result.locked();
        }
        Versioned<byte[]> currentValue = this.getTableMap(tableName).get(key);
        if (currentValue != null) {
            return Result.ok(new UpdateResult<Versioned<byte[]>>(false, currentValue, currentValue));
        }
        this.nextVersion = this.nextVersion + 1L;
        Versioned newValue = new Versioned((Object)value, this.nextVersion.longValue());
        this.getTableMap(tableName).put(key, (Versioned<byte[]>)newValue);
        return Result.ok(new UpdateResult<Versioned>(true, null, newValue));
    }

    @Override
    public Result<Versioned<byte[]>> remove(String tableName, String key) {
        return this.isLockedForUpdates(tableName, key) ? Result.locked() : Result.ok(this.getTableMap(tableName).remove(key));
    }

    @Override
    public Result<Void> clear(String tableName) {
        if (this.areTransactionsInProgress(tableName)) {
            return Result.locked();
        }
        this.getTableMap(tableName).clear();
        return Result.ok(null);
    }

    @Override
    public Set<String> keySet(String tableName) {
        return ImmutableSet.copyOf(this.getTableMap(tableName).keySet());
    }

    @Override
    public Collection<Versioned<byte[]>> values(String tableName) {
        return ImmutableList.copyOf(this.getTableMap(tableName).values());
    }

    @Override
    public Set<Map.Entry<String, Versioned<byte[]>>> entrySet(String tableName) {
        return ImmutableSet.copyOf((Collection)this.getTableMap(tableName).entrySet().stream().map(entry -> Pair.of(entry.getKey(), entry.getValue())).collect(Collectors.toSet()));
    }

    @Override
    public Result<Versioned<byte[]>> putIfAbsent(String tableName, String key, byte[] value) {
        if (this.isLockedForUpdates(tableName, key)) {
            return Result.locked();
        }
        Versioned<byte[]> existingValue = this.get(tableName, key);
        Versioned<byte[]> currentValue = existingValue != null ? existingValue : this.put(tableName, key, value).value();
        return Result.ok(currentValue);
    }

    @Override
    public Result<Boolean> remove(String tableName, String key, byte[] value) {
        if (this.isLockedForUpdates(tableName, key)) {
            return Result.locked();
        }
        Versioned<byte[]> existing = this.get(tableName, key);
        if (existing != null && Arrays.equals((byte[])existing.value(), value)) {
            this.getTableMap(tableName).remove(key);
            return Result.ok(true);
        }
        return Result.ok(false);
    }

    @Override
    public Result<Boolean> remove(String tableName, String key, long version) {
        if (this.isLockedForUpdates(tableName, key)) {
            return Result.locked();
        }
        Versioned<byte[]> existing = this.get(tableName, key);
        if (existing != null && existing.version() == version) {
            this.remove(tableName, key);
            return Result.ok(true);
        }
        return Result.ok(false);
    }

    @Override
    public Result<Boolean> replace(String tableName, String key, byte[] oldValue, byte[] newValue) {
        if (this.isLockedForUpdates(tableName, key)) {
            return Result.locked();
        }
        Versioned<byte[]> existing = this.get(tableName, key);
        if (existing != null && Arrays.equals((byte[])existing.value(), oldValue)) {
            this.put(tableName, key, newValue);
            return Result.ok(true);
        }
        return Result.ok(false);
    }

    @Override
    public Result<Boolean> replace(String tableName, String key, long oldVersion, byte[] newValue) {
        if (this.isLockedForUpdates(tableName, key)) {
            return Result.locked();
        }
        Versioned<byte[]> existing = this.get(tableName, key);
        if (existing != null && existing.version() == oldVersion) {
            this.put(tableName, key, newValue);
            return Result.ok(true);
        }
        return Result.ok(false);
    }

    @Override
    public Result<UpdateResult<Versioned<byte[]>>> replaceAndGet(String tableName, String key, long oldVersion, byte[] newValue) {
        Versioned previous;
        if (this.isLockedForUpdates(tableName, key)) {
            return Result.locked();
        }
        boolean updated = false;
        Versioned current = previous = this.get(tableName, key);
        if (previous != null && previous.version() == oldVersion) {
            this.nextVersion = this.nextVersion + 1L;
            current = new Versioned((Object)newValue, this.nextVersion.longValue());
            this.getTableMap(tableName).put(key, (Versioned<byte[]>)current);
            updated = true;
        }
        return Result.ok(new UpdateResult<Versioned<byte[]>>(updated, previous, current));
    }

    @Override
    public Long counterAddAndGet(String counterName, long delta) {
        return this.getCounter(counterName).addAndGet(delta);
    }

    @Override
    public Long counterGetAndAdd(String counterName, long delta) {
        return this.getCounter(counterName).getAndAdd(delta);
    }

    @Override
    public Long counterGet(String counterName) {
        return this.getCounter(counterName).get();
    }

    @Override
    public Long queueSize(String queueName) {
        return this.getQueue(queueName).size();
    }

    @Override
    public byte[] queuePeek(String queueName) {
        Queue<byte[]> queue = this.getQueue(queueName);
        return queue.peek();
    }

    @Override
    public byte[] queuePop(String queueName, NodeId requestor) {
        Queue<byte[]> queue = this.getQueue(queueName);
        if (queue.size() == 0 && requestor != null) {
            this.getQueueUpdateNotificationTargets(queueName).add(requestor);
            return null;
        }
        return queue.remove();
    }

    @Override
    public Set<NodeId> queuePush(String queueName, byte[] entry) {
        this.getQueue(queueName).add(entry);
        ImmutableSet notifyList = ImmutableSet.copyOf(this.getQueueUpdateNotificationTargets(queueName));
        this.getQueueUpdateNotificationTargets(queueName).clear();
        return notifyList;
    }

    @Override
    public boolean prepareAndCommit(Transaction transaction) {
        if (this.prepare(transaction)) {
            return this.commit(transaction);
        }
        return false;
    }

    @Override
    public boolean prepare(Transaction transaction) {
        if (transaction.updates().stream().anyMatch(update -> this.isLockedByAnotherTransaction(update.tableName(), update.key(), transaction.id()))) {
            return false;
        }
        if (transaction.updates().stream().allMatch(this::isUpdatePossible)) {
            transaction.updates().forEach(update -> this.doProvisionalUpdate((DatabaseUpdate)update, transaction.id()));
            return true;
        }
        return false;
    }

    @Override
    public boolean commit(Transaction transaction) {
        transaction.updates().forEach(update -> this.commitProvisionalUpdate((DatabaseUpdate)update, transaction.id()));
        return true;
    }

    @Override
    public boolean rollback(Transaction transaction) {
        transaction.updates().forEach(update -> this.undoProvisionalUpdate((DatabaseUpdate)update, transaction.id()));
        return true;
    }

    private Map<String, Versioned<byte[]>> getTableMap(String tableName) {
        return this.tables.computeIfAbsent(tableName, name -> Maps.newConcurrentMap());
    }

    private Map<String, Update> getLockMap(String tableName) {
        return this.locks.computeIfAbsent(tableName, name -> Maps.newConcurrentMap());
    }

    private AtomicLong getCounter(String counterName) {
        return this.counters.computeIfAbsent(counterName, name -> new AtomicLong(0L));
    }

    private Queue<byte[]> getQueue(String queueName) {
        return this.queues.computeIfAbsent(queueName, name -> new LinkedList());
    }

    private Set<NodeId> getQueueUpdateNotificationTargets(String queueName) {
        return this.queueUpdateNotificationTargets.computeIfAbsent(queueName, name -> new HashSet());
    }

    private boolean isUpdatePossible(DatabaseUpdate update) {
        Versioned<byte[]> existingEntry = this.get(update.tableName(), update.key());
        switch (update.type()) {
            case PUT: 
            case REMOVE: {
                return true;
            }
            case PUT_IF_ABSENT: {
                return existingEntry == null;
            }
            case PUT_IF_VERSION_MATCH: {
                return existingEntry != null && existingEntry.version() == update.currentVersion();
            }
            case PUT_IF_VALUE_MATCH: {
                return existingEntry != null && Arrays.equals((byte[])existingEntry.value(), update.currentValue());
            }
            case REMOVE_IF_VERSION_MATCH: {
                return existingEntry == null || existingEntry.version() == update.currentVersion();
            }
            case REMOVE_IF_VALUE_MATCH: {
                return existingEntry == null || Arrays.equals((byte[])existingEntry.value(), update.currentValue());
            }
        }
        throw new IllegalStateException("Unsupported type: " + update.type());
    }

    private void doProvisionalUpdate(DatabaseUpdate update, long transactionId) {
        Map<String, Update> lockMap = this.getLockMap(update.tableName());
        switch (update.type()) {
            case PUT: 
            case PUT_IF_ABSENT: 
            case PUT_IF_VERSION_MATCH: 
            case PUT_IF_VALUE_MATCH: {
                lockMap.put(update.key(), new Update(transactionId, update.value()));
                break;
            }
            case REMOVE: 
            case REMOVE_IF_VERSION_MATCH: 
            case REMOVE_IF_VALUE_MATCH: {
                lockMap.put(update.key(), new Update(transactionId, null));
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported type: " + update.type());
            }
        }
    }

    private void commitProvisionalUpdate(DatabaseUpdate update, long transactionId) {
        String tableName = update.tableName();
        String key = update.key();
        DatabaseUpdate.Type type = update.type();
        Update provisionalUpdate = this.getLockMap(tableName).get(key);
        if (!Objects.equal((Object)transactionId, (Object)provisionalUpdate.transactionId())) {
            return;
        }
        this.getLockMap(tableName).remove(key);
        switch (type) {
            case PUT: 
            case PUT_IF_ABSENT: 
            case PUT_IF_VERSION_MATCH: 
            case PUT_IF_VALUE_MATCH: {
                this.put(tableName, key, provisionalUpdate.value());
                break;
            }
            case REMOVE: 
            case REMOVE_IF_VERSION_MATCH: 
            case REMOVE_IF_VALUE_MATCH: {
                this.remove(tableName, key);
                break;
            }
        }
    }

    private void undoProvisionalUpdate(DatabaseUpdate update, long transactionId) {
        String tableName = update.tableName();
        String key = update.key();
        Update provisionalUpdate = this.getLockMap(tableName).get(key);
        if (provisionalUpdate == null) {
            return;
        }
        if (Objects.equal((Object)transactionId, (Object)provisionalUpdate.transactionId())) {
            this.getLockMap(tableName).remove(key);
        }
    }

    private boolean isLockedByAnotherTransaction(String tableName, String key, long transactionId) {
        Update update = this.getLockMap(tableName).get(key);
        return update != null && !Objects.equal((Object)transactionId, (Object)update.transactionId());
    }

    private boolean isLockedForUpdates(String tableName, String key) {
        return this.getLockMap(tableName).containsKey(key);
    }

    private boolean areTransactionsInProgress(String tableName) {
        return !this.getLockMap(tableName).isEmpty();
    }

    private class Update {
        private final long transactionId;
        private final byte[] value;

        public Update(long txId, byte[] value) {
            this.transactionId = txId;
            this.value = value;
        }

        public long transactionId() {
            return this.transactionId;
        }

        public byte[] value() {
            return this.value;
        }
    }
}

