/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.function.Consumer;
import org.onosproject.cluster.NodeId;
import org.onosproject.store.consistent.impl.DatabaseManager;
import org.onosproject.store.consistent.impl.DefaultDistributedQueue;
import org.onosproject.store.service.DistributedQueue;
import org.onosproject.store.service.DistributedQueueBuilder;
import org.onosproject.store.service.Serializer;

public class DefaultDistributedQueueBuilder<E>
implements DistributedQueueBuilder<E> {
    private Serializer serializer;
    private String name;
    private boolean persistenceEnabled = true;
    private final DatabaseManager databaseManager;

    public DefaultDistributedQueueBuilder(DatabaseManager databaseManager) {
        this.databaseManager = databaseManager;
    }

    public DistributedQueueBuilder<E> withName(String name) {
        Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0);
        this.name = name;
        return this;
    }

    public DistributedQueueBuilder<E> withSerializer(Serializer serializer) {
        Preconditions.checkArgument((serializer != null ? 1 : 0) != 0);
        this.serializer = serializer;
        return this;
    }

    public DistributedQueueBuilder<E> withPersistenceDisabled() {
        this.persistenceEnabled = false;
        return this;
    }

    private boolean validInputs() {
        return this.name != null && this.serializer != null;
    }

    public DistributedQueue<E> build() {
        Preconditions.checkState((boolean)this.validInputs());
        Consumer<Set<NodeId>> notifyOthers = nodes -> this.databaseManager.clusterCommunicator.multicast((Object)this.name, DatabaseManager.QUEUE_UPDATED_TOPIC, s -> s.getBytes(Charsets.UTF_8), nodes);
        DefaultDistributedQueue queue = new DefaultDistributedQueue(this.name, this.persistenceEnabled ? this.databaseManager.partitionedDatabase : this.databaseManager.inMemoryDatabase, this.serializer, this.databaseManager.localNodeId, notifyOthers);
        this.databaseManager.registerQueue(queue);
        return queue;
    }
}

