/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.ecmap;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.store.Timestamp;

public abstract class AbstractEntry<K, V>
implements Comparable<AbstractEntry<K, V>> {
    private final K key;
    private final Timestamp timestamp;

    public AbstractEntry(K key, Timestamp timestamp) {
        this.key = Preconditions.checkNotNull(key);
        this.timestamp = (Timestamp)Preconditions.checkNotNull((Object)timestamp);
    }

    protected AbstractEntry() {
        this.key = null;
        this.timestamp = null;
    }

    public K key() {
        return this.key;
    }

    public Timestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public int compareTo(AbstractEntry<K, V> o) {
        return this.timestamp.compareTo((Object)o.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AbstractEntry) {
            AbstractEntry that = (AbstractEntry)o;
            return this.timestamp.equals((Object)that.timestamp);
        }
        return false;
    }
}

