/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Preconditions;
import org.onosproject.core.ApplicationId;
import org.onosproject.store.consistent.impl.DatabaseManager;
import org.onosproject.store.consistent.impl.DefaultAsyncConsistentMap;
import org.onosproject.store.consistent.impl.DefaultConsistentMap;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;

public class DefaultConsistentMapBuilder<K, V>
implements ConsistentMapBuilder<K, V> {
    private Serializer serializer;
    private String name;
    private ApplicationId applicationId;
    private boolean purgeOnUninstall = false;
    private boolean partitionsEnabled = true;
    private boolean readOnly = false;
    private final DatabaseManager manager;

    public DefaultConsistentMapBuilder(DatabaseManager manager) {
        this.manager = manager;
    }

    public ConsistentMapBuilder<K, V> withName(String name) {
        Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0);
        this.name = name;
        return this;
    }

    public ConsistentMapBuilder<K, V> withApplicationId(ApplicationId id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0);
        this.applicationId = id;
        return this;
    }

    public ConsistentMapBuilder<K, V> withPurgeOnUninstall() {
        this.purgeOnUninstall = true;
        return this;
    }

    public ConsistentMapBuilder<K, V> withSerializer(Serializer serializer) {
        Preconditions.checkArgument((serializer != null ? 1 : 0) != 0);
        this.serializer = serializer;
        return this;
    }

    public ConsistentMapBuilder<K, V> withPartitionsDisabled() {
        this.partitionsEnabled = false;
        return this;
    }

    public ConsistentMapBuilder<K, V> withUpdatesDisabled() {
        this.readOnly = true;
        return this;
    }

    private void validateInputs() {
        Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"name must be specified");
        Preconditions.checkState((this.serializer != null ? 1 : 0) != 0, (Object)"serializer must be specified");
        if (this.purgeOnUninstall) {
            Preconditions.checkState((this.applicationId != null ? 1 : 0) != 0, (Object)"ApplicationId must be specified when purgeOnUninstall is enabled");
        }
    }

    public ConsistentMap<K, V> build() {
        return new DefaultConsistentMap<K, V>(this.buildAndRegisterMap());
    }

    public AsyncConsistentMap<K, V> buildAsyncMap() {
        return this.buildAndRegisterMap();
    }

    private DefaultAsyncConsistentMap<K, V> buildAndRegisterMap() {
        this.validateInputs();
        DefaultAsyncConsistentMap asyncMap = new DefaultAsyncConsistentMap(this.name, this.applicationId, this.partitionsEnabled ? this.manager.partitionedDatabase : this.manager.inMemoryDatabase, this.serializer, this.readOnly, this.purgeOnUninstall, event -> this.manager.clusterCommunicator.broadcast(event, DatabaseManager.mapUpdatesSubject(this.name), arg_0 -> ((Serializer)this.serializer).encode(arg_0)));
        return this.manager.registerMap(asyncMap);
    }
}

