/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.mastership.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipEventListener;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.event.Event;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipStore;
import org.onosproject.mastership.MastershipStoreDelegate;
import org.onosproject.mastership.MastershipTerm;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.serializers.KryoSerializer;
import org.onosproject.store.serializers.StoreSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class ConsistentDeviceMastershipStore
extends AbstractStore<MastershipEvent, MastershipStoreDelegate>
implements MastershipStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LeadershipService leadershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    private NodeId localNodeId;
    private final Set<DeviceId> connectedDevices = Sets.newHashSet();
    private static final MessageSubject ROLE_RELINQUISH_SUBJECT = new MessageSubject("mastership-store-device-role-relinquish");
    private static final MessageSubject TRANSITION_FROM_MASTER_TO_STANDBY_SUBJECT = new MessageSubject("mastership-store-device-mastership-relinquish");
    private static final Pattern DEVICE_MASTERSHIP_TOPIC_PATTERN = Pattern.compile("device:(.*)");
    private ExecutorService messageHandlingExecutor;
    private ScheduledExecutorService transferExecutor;
    private final LeadershipEventListener leadershipEventListener = new InternalDeviceMastershipEventListener();
    private static final String NODE_ID_NULL = "Node ID cannot be null";
    private static final String DEVICE_ID_NULL = "Device ID cannot be null";
    private static final int WAIT_BEFORE_MASTERSHIP_HANDOFF_MILLIS = 3000;
    public static final StoreSerializer SERIALIZER = new KryoSerializer(){

        protected void setupKryoPool() {
            this.serializerPool = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{MastershipRole.class}).register(new Class[]{MastershipEvent.class}).register(new Class[]{MastershipEvent.Type.class}).build();
        }
    };

    @Activate
    public void activate() {
        this.messageHandlingExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/store/device/mastership", (String)"message-handler"));
        this.transferExecutor = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/store/device/mastership", (String)"mastership-transfer-executor"));
        this.clusterCommunicator.addSubscriber(ROLE_RELINQUISH_SUBJECT, arg_0 -> ((StoreSerializer)SERIALIZER).decode(arg_0), this::relinquishLocalRole, arg_0 -> ((StoreSerializer)SERIALIZER).encode(arg_0), (Executor)this.messageHandlingExecutor);
        this.clusterCommunicator.addSubscriber(TRANSITION_FROM_MASTER_TO_STANDBY_SUBJECT, arg_0 -> ((StoreSerializer)SERIALIZER).decode(arg_0), this::transitionFromMasterToStandby, arg_0 -> ((StoreSerializer)SERIALIZER).encode(arg_0), (Executor)this.messageHandlingExecutor);
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.leadershipService.addListener(this.leadershipEventListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.clusterCommunicator.removeSubscriber(ROLE_RELINQUISH_SUBJECT);
        this.clusterCommunicator.removeSubscriber(TRANSITION_FROM_MASTER_TO_STANDBY_SUBJECT);
        this.messageHandlingExecutor.shutdown();
        this.transferExecutor.shutdown();
        this.leadershipService.removeListener(this.leadershipEventListener);
        this.log.info("Stopped");
    }

    public CompletableFuture<MastershipRole> requestRole(DeviceId deviceId) {
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        String leadershipTopic = this.createDeviceMastershipTopic(deviceId);
        if (this.connectedDevices.add(deviceId)) {
            return this.leadershipService.runForLeadership(leadershipTopic).thenApply(leadership -> Objects.equal((Object)this.localNodeId, (Object)leadership.leader()) ? MastershipRole.MASTER : MastershipRole.STANDBY);
        }
        NodeId leader = this.leadershipService.getLeader(leadershipTopic);
        if (Objects.equal((Object)this.localNodeId, (Object)leader)) {
            return CompletableFuture.completedFuture(MastershipRole.MASTER);
        }
        return CompletableFuture.completedFuture(MastershipRole.STANDBY);
    }

    public MastershipRole getRole(NodeId nodeId, DeviceId deviceId) {
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)NODE_ID_NULL);
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        String leadershipTopic = this.createDeviceMastershipTopic(deviceId);
        NodeId leader = this.leadershipService.getLeader(leadershipTopic);
        if (Objects.equal((Object)nodeId, (Object)leader)) {
            return MastershipRole.MASTER;
        }
        return this.leadershipService.getCandidates(leadershipTopic).contains(nodeId) ? MastershipRole.STANDBY : MastershipRole.NONE;
    }

    public NodeId getMaster(DeviceId deviceId) {
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        String leadershipTopic = this.createDeviceMastershipTopic(deviceId);
        return this.leadershipService.getLeader(leadershipTopic);
    }

    public RoleInfo getNodes(DeviceId deviceId) {
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        HashMap roles = Maps.newHashMap();
        this.clusterService.getNodes().forEach(node -> roles.put(node.id(), this.getRole(node.id(), deviceId)));
        NodeId master = null;
        LinkedList standbys = Lists.newLinkedList();
        List candidates = this.leadershipService.getCandidates(this.createDeviceMastershipTopic(deviceId));
        for (Map.Entry entry : roles.entrySet()) {
            if (entry.getValue() == MastershipRole.MASTER) {
                master = (NodeId)entry.getKey();
                continue;
            }
            if (entry.getValue() != MastershipRole.STANDBY) continue;
            standbys.add(entry.getKey());
        }
        List sortedStandbyList = candidates.stream().filter(standbys::contains).collect(Collectors.toList());
        return new RoleInfo(master, sortedStandbyList);
    }

    public Set<DeviceId> getDevices(NodeId nodeId) {
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)NODE_ID_NULL);
        return this.leadershipService.ownedTopics(nodeId).stream().filter(this::isDeviceMastershipTopic).map(this::extractDeviceIdFromTopic).collect(Collectors.toSet());
    }

    public CompletableFuture<MastershipEvent> setMaster(NodeId nodeId, DeviceId deviceId) {
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)NODE_ID_NULL);
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        NodeId currentMaster = this.getMaster(deviceId);
        if (nodeId.equals((Object)currentMaster)) {
            return CompletableFuture.completedFuture(null);
        }
        String leadershipTopic = this.createDeviceMastershipTopic(deviceId);
        List candidates = this.leadershipService.getCandidates(leadershipTopic);
        if (candidates.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.leadershipService.makeTopCandidate(leadershipTopic, nodeId)) {
            CompletableFuture<MastershipEvent> result = new CompletableFuture<MastershipEvent>();
            this.transferExecutor.schedule(() -> result.complete(this.transitionFromMasterToStandby(deviceId)), 3000L, TimeUnit.MILLISECONDS);
            return result;
        }
        this.log.warn("Failed to promote {} to mastership for {}", (Object)nodeId, (Object)deviceId);
        return CompletableFuture.completedFuture(null);
    }

    public MastershipTerm getTermFor(DeviceId deviceId) {
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        String leadershipTopic = this.createDeviceMastershipTopic(deviceId);
        Leadership leadership = this.leadershipService.getLeadership(leadershipTopic);
        return leadership != null ? MastershipTerm.of((NodeId)leadership.leader(), (long)leadership.epoch()) : null;
    }

    public CompletableFuture<MastershipEvent> setStandby(NodeId nodeId, DeviceId deviceId) {
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)NODE_ID_NULL);
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        NodeId currentMaster = this.getMaster(deviceId);
        if (!nodeId.equals((Object)currentMaster)) {
            return CompletableFuture.completedFuture(null);
        }
        String leadershipTopic = this.createDeviceMastershipTopic(deviceId);
        List candidates = this.leadershipService.getCandidates(leadershipTopic);
        NodeId newMaster = candidates.stream().filter(candidate -> !Objects.equal((Object)nodeId, (Object)candidate)).findFirst().orElse(null);
        this.log.info("Transitioning to role {} for {}. Next master: {}", new Object[]{newMaster != null ? MastershipRole.STANDBY : MastershipRole.NONE, deviceId, newMaster});
        if (newMaster != null) {
            return this.setMaster(newMaster, deviceId);
        }
        return this.relinquishRole(nodeId, deviceId);
    }

    public CompletableFuture<MastershipEvent> relinquishRole(NodeId nodeId, DeviceId deviceId) {
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)NODE_ID_NULL);
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        if (nodeId.equals((Object)this.localNodeId)) {
            return this.relinquishLocalRole(deviceId);
        }
        this.log.debug("Forwarding request to relinquish role for device {} to {}", (Object)deviceId, (Object)nodeId);
        return this.clusterCommunicator.sendAndReceive((Object)deviceId, ROLE_RELINQUISH_SUBJECT, arg_0 -> ((StoreSerializer)SERIALIZER).encode(arg_0), arg_0 -> ((StoreSerializer)SERIALIZER).decode(arg_0), nodeId);
    }

    private CompletableFuture<MastershipEvent> relinquishLocalRole(DeviceId deviceId) {
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        if (!this.connectedDevices.contains(deviceId)) {
            return CompletableFuture.completedFuture(null);
        }
        String leadershipTopic = this.createDeviceMastershipTopic(deviceId);
        NodeId currentLeader = this.leadershipService.getLeader(leadershipTopic);
        MastershipEvent.Type eventType = Objects.equal((Object)currentLeader, (Object)this.localNodeId) ? MastershipEvent.Type.MASTER_CHANGED : MastershipEvent.Type.BACKUPS_CHANGED;
        this.connectedDevices.remove(deviceId);
        return this.leadershipService.withdraw(leadershipTopic).thenApply(v -> new MastershipEvent(eventType, deviceId, this.getNodes(deviceId)));
    }

    private MastershipEvent transitionFromMasterToStandby(DeviceId deviceId) {
        Preconditions.checkArgument((deviceId != null ? 1 : 0) != 0, (Object)DEVICE_ID_NULL);
        NodeId currentMaster = this.getMaster(deviceId);
        if (currentMaster == null) {
            return null;
        }
        if (!currentMaster.equals((Object)this.localNodeId)) {
            this.log.info("Forwarding request to relinquish mastership for device {} to {}", (Object)deviceId, (Object)currentMaster);
            return (MastershipEvent)Tools.futureGetOrElse((Future)this.clusterCommunicator.sendAndReceive((Object)deviceId, TRANSITION_FROM_MASTER_TO_STANDBY_SUBJECT, arg_0 -> ((StoreSerializer)SERIALIZER).encode(arg_0), arg_0 -> ((StoreSerializer)SERIALIZER).decode(arg_0), currentMaster), null);
        }
        return this.leadershipService.stepdown(this.createDeviceMastershipTopic(deviceId)) ? new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, this.getNodes(deviceId)) : null;
    }

    public void relinquishAllRole(NodeId nodeId) {
    }

    private String createDeviceMastershipTopic(DeviceId deviceId) {
        return String.format("device:%s", deviceId.toString());
    }

    private DeviceId extractDeviceIdFromTopic(String topic) {
        Matcher m = DEVICE_MASTERSHIP_TOPIC_PATTERN.matcher(topic);
        if (m.matches()) {
            return DeviceId.deviceId((String)m.group(1));
        }
        throw new IllegalArgumentException("Invalid device mastership topic: " + topic);
    }

    private boolean isDeviceMastershipTopic(String topic) {
        Matcher m = DEVICE_MASTERSHIP_TOPIC_PATTERN.matcher(topic);
        return m.matches();
    }

    protected void bindLeadershipService(LeadershipService leadershipService) {
        this.leadershipService = leadershipService;
    }

    protected void unbindLeadershipService(LeadershipService leadershipService) {
        if (this.leadershipService == leadershipService) {
            this.leadershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    private class InternalDeviceMastershipEventListener
    implements LeadershipEventListener {
        private InternalDeviceMastershipEventListener() {
        }

        public void event(LeadershipEvent event) {
            Leadership leadership = (Leadership)event.subject();
            if (!ConsistentDeviceMastershipStore.this.isDeviceMastershipTopic(leadership.topic())) {
                return;
            }
            DeviceId deviceId = ConsistentDeviceMastershipStore.this.extractDeviceIdFromTopic(leadership.topic());
            switch ((LeadershipEvent.Type)event.type()) {
                case LEADER_ELECTED: {
                    ConsistentDeviceMastershipStore.this.notifyDelegate((Event)new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, ConsistentDeviceMastershipStore.this.getNodes(deviceId)));
                    break;
                }
                case LEADER_REELECTED: {
                    throw new IllegalStateException("Unexpected event type");
                }
                case LEADER_BOOTED: {
                    ConsistentDeviceMastershipStore.this.notifyDelegate((Event)new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, ConsistentDeviceMastershipStore.this.getNodes(deviceId)));
                    break;
                }
                case CANDIDATES_CHANGED: {
                    ConsistentDeviceMastershipStore.this.notifyDelegate((Event)new MastershipEvent(MastershipEvent.Type.BACKUPS_CHANGED, deviceId, ConsistentDeviceMastershipStore.this.getNodes(deviceId)));
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }
}

