/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.mastership.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.net.MastershipRole;

final class RoleValue {
    protected final Map<MastershipRole, List<NodeId>> value = new EnumMap<MastershipRole, List<NodeId>>(MastershipRole.class);

    public RoleValue() {
        this.value.put(MastershipRole.MASTER, new LinkedList());
        this.value.put(MastershipRole.STANDBY, new LinkedList());
        this.value.put(MastershipRole.NONE, new LinkedList());
    }

    public RoleValue(RoleValue original) {
        this.value.put(MastershipRole.MASTER, Lists.newLinkedList((Iterable)original.value.get(MastershipRole.MASTER)));
        this.value.put(MastershipRole.STANDBY, Lists.newLinkedList((Iterable)original.value.get(MastershipRole.STANDBY)));
        this.value.put(MastershipRole.NONE, Lists.newLinkedList((Iterable)original.value.get(MastershipRole.NONE)));
    }

    Map<MastershipRole, List<NodeId>> value() {
        return Collections.unmodifiableMap(this.value);
    }

    public List<NodeId> nodesOfRole(MastershipRole type) {
        return this.value.get(type);
    }

    public NodeId get(MastershipRole type) {
        return this.value.get(type).isEmpty() ? null : this.value.get(type).get(0);
    }

    public boolean contains(MastershipRole type, NodeId nodeId) {
        return this.value.get(type).contains(nodeId);
    }

    public MastershipRole getRole(NodeId nodeId) {
        if (this.contains(MastershipRole.MASTER, nodeId)) {
            return MastershipRole.MASTER;
        }
        if (this.contains(MastershipRole.STANDBY, nodeId)) {
            return MastershipRole.STANDBY;
        }
        return MastershipRole.NONE;
    }

    public boolean add(MastershipRole type, NodeId nodeId) {
        List<NodeId> nodes = this.value.get(type);
        if (!nodes.contains(nodeId)) {
            return nodes.add(nodeId);
        }
        return false;
    }

    public boolean remove(MastershipRole type, NodeId nodeId) {
        List<NodeId> nodes = this.value.get(type);
        if (!nodes.isEmpty()) {
            return nodes.remove(nodeId);
        }
        return false;
    }

    public boolean reassign(NodeId nodeId, MastershipRole from, MastershipRole to) {
        boolean modified = this.remove(from, nodeId);
        return modified |= this.add(to, nodeId);
    }

    public boolean replace(NodeId from, NodeId to, MastershipRole type) {
        boolean modified = this.remove(type, from);
        return modified |= this.add(type, to);
    }

    public RoleInfo roleInfo() {
        return new RoleInfo(this.get(MastershipRole.MASTER), this.nodesOfRole(MastershipRole.STANDBY));
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this.getClass());
        for (Map.Entry<MastershipRole, List<NodeId>> el : this.value.entrySet()) {
            helper.add(el.getKey().toString(), el.getValue());
        }
        return helper.toString();
    }
}

