/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.onosproject.store.cluster.impl.NodeInfo;

public class DatabaseDefinition {
    private Map<String, Set<NodeInfo>> partitions;
    private Set<NodeInfo> nodes;

    public static DatabaseDefinition from(Map<String, Set<NodeInfo>> partitions, Set<NodeInfo> nodes) {
        Preconditions.checkNotNull(partitions);
        Preconditions.checkNotNull(nodes);
        DatabaseDefinition definition = new DatabaseDefinition();
        definition.partitions = ImmutableMap.copyOf(partitions);
        definition.nodes = ImmutableSet.copyOf(nodes);
        return definition;
    }

    public static DatabaseDefinition from(Set<NodeInfo> nodes) {
        return DatabaseDefinition.from(DatabaseDefinition.generateDefaultPartitions(nodes), nodes);
    }

    public Map<String, Set<NodeInfo>> getPartitions() {
        return this.partitions;
    }

    public Set<NodeInfo> getNodes() {
        return this.nodes;
    }

    private static Map<String, Set<NodeInfo>> generateDefaultPartitions(Set<NodeInfo> nodes) {
        ArrayList<NodeInfo> sorted = new ArrayList<NodeInfo>(nodes);
        Collections.sort(sorted, (o1, o2) -> o1.getId().compareTo(o2.getId()));
        HashMap partitions = Maps.newHashMap();
        int length = nodes.size();
        int count = 3;
        for (int i = 0; i < length; ++i) {
            HashSet set = new HashSet(count);
            for (int j = 0; j < count; ++j) {
                set.add(sorted.get((i + j) % length));
            }
            partitions.put("p" + (i + 1), set);
        }
        return partitions;
    }
}

