/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.service.AsyncAtomicCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncAtomicCounter
implements AsyncAtomicCounter {
    private final String name;
    private final Database database;
    private final boolean retryOnFailure;
    private final ScheduledExecutorService retryExecutor;
    private static final int DELAY_BETWEEN_RETRY_SEC = 1;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public DefaultAsyncAtomicCounter(String name, Database database, boolean retryOnException, ScheduledExecutorService retryExecutor) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.database = (Database)Preconditions.checkNotNull((Object)database);
        this.retryOnFailure = retryOnException;
        this.retryExecutor = retryExecutor;
    }

    public CompletableFuture<Long> incrementAndGet() {
        return this.addAndGet(1L);
    }

    public CompletableFuture<Long> get() {
        return this.database.counterGet(this.name);
    }

    public CompletableFuture<Long> getAndIncrement() {
        return this.getAndAdd(1L);
    }

    public CompletableFuture<Long> getAndAdd(long delta) {
        CompletableFuture<Long> result = this.database.counterGetAndAdd(this.name, delta);
        if (!this.retryOnFailure) {
            return result;
        }
        CompletableFuture future = new CompletableFuture();
        return ((CompletableFuture)result.whenComplete((r, e) -> {
            if (e != null) {
                this.log.warn("getAndAdd failed due to {}. Will retry", (Object)e.getMessage());
                this.retryExecutor.schedule(new RetryTask(this.database::counterGetAndAdd, delta, future), 1L, TimeUnit.SECONDS);
            } else {
                future.complete(r);
            }
        })).thenCompose(v -> future);
    }

    public CompletableFuture<Long> addAndGet(long delta) {
        CompletableFuture<Long> result = this.database.counterAddAndGet(this.name, delta);
        if (!this.retryOnFailure) {
            return result;
        }
        CompletableFuture future = new CompletableFuture();
        return ((CompletableFuture)result.whenComplete((r, e) -> {
            if (e != null) {
                this.log.warn("addAndGet failed due to {}. Will retry", (Object)e.getMessage());
                this.retryExecutor.schedule(new RetryTask(this.database::counterAddAndGet, delta, future), 1L, TimeUnit.SECONDS);
            } else {
                future.complete(r);
            }
        })).thenCompose(v -> future);
    }

    private class RetryTask
    implements Runnable {
        private final BiFunction<String, Long, CompletableFuture<Long>> function;
        private final Long delta;
        private final CompletableFuture<Long> result;

        public RetryTask(BiFunction<String, Long, CompletableFuture<Long>> function, Long delta, CompletableFuture<Long> result) {
            this.function = function;
            this.delta = delta;
            this.result = result;
        }

        @Override
        public void run() {
            this.function.apply(DefaultAsyncAtomicCounter.this.name, this.delta).whenComplete((r, e) -> {
                if (e == null) {
                    this.result.complete((Long)r);
                } else {
                    DefaultAsyncAtomicCounter.this.log.warn("{} retry failed due to {}. Will try again...", this.function, (Object)e.getMessage());
                    DefaultAsyncAtomicCounter.this.retryExecutor.schedule(this, 1L, TimeUnit.SECONDS);
                }
            });
        }
    }
}

