/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Preconditions;
import java.util.concurrent.ScheduledExecutorService;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.DefaultAsyncAtomicCounter;
import org.onosproject.store.consistent.impl.DefaultAtomicCounter;
import org.onosproject.store.service.AsyncAtomicCounter;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.AtomicCounterBuilder;

public class DefaultAtomicCounterBuilder
implements AtomicCounterBuilder {
    private String name;
    private boolean partitionsEnabled = true;
    private final Database partitionedDatabase;
    private final Database inMemoryDatabase;
    private boolean retryOnFailure = false;
    private ScheduledExecutorService retryExecutor = null;

    public DefaultAtomicCounterBuilder(Database inMemoryDatabase, Database partitionedDatabase) {
        this.inMemoryDatabase = inMemoryDatabase;
        this.partitionedDatabase = partitionedDatabase;
    }

    public AtomicCounterBuilder withName(String name) {
        Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0);
        this.name = name;
        return this;
    }

    public AtomicCounterBuilder withPartitionsDisabled() {
        this.partitionsEnabled = false;
        return this;
    }

    public AtomicCounter build() {
        this.validateInputs();
        Database database = this.partitionsEnabled ? this.partitionedDatabase : this.inMemoryDatabase;
        return new DefaultAtomicCounter(this.name, database, this.retryOnFailure, this.retryExecutor);
    }

    public AsyncAtomicCounter buildAsyncCounter() {
        this.validateInputs();
        Database database = this.partitionsEnabled ? this.partitionedDatabase : this.inMemoryDatabase;
        return new DefaultAsyncAtomicCounter(this.name, database, this.retryOnFailure, this.retryExecutor);
    }

    public AtomicCounterBuilder withRetryOnFailure() {
        this.retryOnFailure = true;
        return this;
    }

    public AtomicCounterBuilder withRetryExecutor(ScheduledExecutorService executor) {
        this.retryExecutor = executor;
        return this;
    }

    private void validateInputs() {
        if (this.retryOnFailure && this.retryExecutor == null) {
            throw new IllegalArgumentException("RetryExecutor must be specified when retries are enabled");
        }
    }
}

