/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.onosproject.cluster.NodeId;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.service.DistributedQueue;
import org.onosproject.store.service.Serializer;

public class DefaultDistributedQueue<E>
implements DistributedQueue<E> {
    private final String name;
    private final Database database;
    private final Serializer serializer;
    private final NodeId localNodeId;
    private final Set<CompletableFuture<E>> pendingFutures = Sets.newIdentityHashSet();
    private final Consumer<Set<NodeId>> notifyConsumers;
    private static final String ERROR_NULL_ENTRY = "Null entries are not allowed";

    public DefaultDistributedQueue(String name, Database database, Serializer serializer, NodeId localNodeId, Consumer<Set<NodeId>> notifyConsumers) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"queue name cannot be null");
        this.database = (Database)Preconditions.checkNotNull((Object)database, (Object)"database cannot be null");
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
        this.localNodeId = localNodeId;
        this.notifyConsumers = notifyConsumers;
    }

    public long size() {
        return (Long)Futures.getUnchecked(this.database.queueSize(this.name));
    }

    public void push(E entry) {
        Preconditions.checkNotNull(entry, (Object)ERROR_NULL_ENTRY);
        Futures.getUnchecked((Future)((Object)((CompletableFuture)this.database.queuePush(this.name, this.serializer.encode(entry)).thenAccept((Consumer)this.notifyConsumers)).thenApply(v -> null)));
    }

    public CompletableFuture<E> pop() {
        return this.database.queuePop(this.name, this.localNodeId).thenCompose(v -> {
            if (v != null) {
                return CompletableFuture.completedFuture(this.serializer.decode(v));
            }
            CompletableFuture newPendingFuture = new CompletableFuture();
            this.pendingFutures.add(newPendingFuture);
            return newPendingFuture;
        });
    }

    public E peek() {
        return (E)Futures.getUnchecked((Future)((Object)this.database.queuePeek(this.name).thenApply(v -> v != null ? this.serializer.decode(v) : null)));
    }

    public String name() {
        return this.name;
    }

    protected void tryPoll() {
        HashSet completedFutures = Sets.newHashSet();
        for (CompletableFuture<E> future : this.pendingFutures) {
            Object entry = Futures.getUnchecked((Future)((Object)this.database.queuePop(this.name, this.localNodeId).thenApply(v -> v != null ? this.serializer.decode(v) : null)));
            if (entry == null) break;
            future.complete(entry);
            completedFutures.add(future);
        }
        this.pendingFutures.removeAll(completedFutures);
    }
}

