/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.SetEvent;
import org.onosproject.store.service.SetEventListener;

public class DefaultDistributedSet<E>
implements DistributedSet<E> {
    private final String name;
    private final ConsistentMap<E, Boolean> backingMap;
    private final Map<SetEventListener<E>, MapEventListener<E, Boolean>> listenerMapping = Maps.newIdentityHashMap();

    public DefaultDistributedSet(String name, ConsistentMap<E, Boolean> backingMap) {
        this.name = name;
        this.backingMap = backingMap;
    }

    public int size() {
        return this.backingMap.size();
    }

    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    public boolean contains(Object o) {
        return this.backingMap.containsKey(o);
    }

    public Iterator<E> iterator() {
        return this.backingMap.keySet().iterator();
    }

    public Object[] toArray() {
        return this.backingMap.keySet().stream().toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.backingMap.keySet().stream().toArray(size -> a);
    }

    public boolean add(E e) {
        return this.backingMap.putIfAbsent(e, (Object)true) == null;
    }

    public boolean remove(Object o) {
        return this.backingMap.remove(o) != null;
    }

    public boolean containsAll(Collection<?> c) {
        return c.stream().allMatch(this::contains);
    }

    public boolean addAll(Collection<? extends E> c) {
        return c.stream().map(this::add).reduce(Boolean::logicalOr).orElse(false);
    }

    public boolean retainAll(Collection<?> c) {
        HashSet retainSet = Sets.newHashSet(c);
        return this.backingMap.keySet().stream().filter(k -> !retainSet.contains(k)).map(this::remove).reduce(Boolean::logicalOr).orElse(false);
    }

    public boolean removeAll(Collection<?> c) {
        HashSet removeSet = Sets.newHashSet(c);
        return this.backingMap.keySet().stream().filter(removeSet::contains).map(this::remove).reduce(Boolean::logicalOr).orElse(false);
    }

    public void clear() {
        this.backingMap.clear();
    }

    public void addListener(SetEventListener<E> listener) {
        MapEventListener mapEventListener = mapEvent -> {
            if (mapEvent.type() == MapEvent.Type.INSERT) {
                listener.event(new SetEvent(this.name, SetEvent.Type.ADD, mapEvent.key()));
            } else if (mapEvent.type() == MapEvent.Type.REMOVE) {
                listener.event(new SetEvent(this.name, SetEvent.Type.REMOVE, mapEvent.key()));
            }
        };
        if (this.listenerMapping.putIfAbsent(listener, mapEventListener) == null) {
            this.backingMap.addListener(mapEventListener);
        }
    }

    public void removeListener(SetEventListener<E> listener) {
        MapEventListener<E, Boolean> mapEventListener = this.listenerMapping.remove(listener);
        if (mapEventListener != null) {
            this.backingMap.removeListener(mapEventListener);
        }
    }
}

