/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onlab.util.HexString;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.DatabaseUpdate;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionalMap;
import org.onosproject.store.service.Versioned;

public class DefaultTransactionalMap<K, V>
implements TransactionalMap<K, V> {
    private final TransactionContext txContext;
    private static final String TX_CLOSED_ERROR = "Transaction is closed";
    private final ConsistentMap<K, V> backingMap;
    private final String name;
    private final Serializer serializer;
    private final Map<K, Versioned<V>> readCache = Maps.newConcurrentMap();
    private final Map<K, V> writeCache = Maps.newConcurrentMap();
    private final Set<K> deleteSet = Sets.newConcurrentHashSet();
    private static final String ERROR_NULL_VALUE = "Null values are not allowed";
    private static final String ERROR_NULL_KEY = "Null key is not allowed";
    private final LoadingCache<K, String> keyCache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<K, String>(){

        public String load(K key) {
            return HexString.toHexString((byte[])DefaultTransactionalMap.this.serializer.encode(key));
        }
    });

    protected K dK(String key) {
        return (K)this.serializer.decode(HexString.fromHexString((String)key));
    }

    public DefaultTransactionalMap(String name, ConsistentMap<K, V> backingMap, TransactionContext txContext, Serializer serializer) {
        this.name = name;
        this.backingMap = backingMap;
        this.txContext = txContext;
        this.serializer = serializer;
    }

    public V get(K key) {
        Preconditions.checkState((boolean)this.txContext.isOpen(), (Object)TX_CLOSED_ERROR);
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        if (this.deleteSet.contains(key)) {
            return null;
        }
        V latest = this.writeCache.get(key);
        if (latest != null) {
            return latest;
        }
        Versioned v = this.readCache.computeIfAbsent(key, k -> this.backingMap.get(k));
        return (V)(v != null ? v.value() : null);
    }

    public V put(K key, V value) {
        Preconditions.checkState((boolean)this.txContext.isOpen(), (Object)TX_CLOSED_ERROR);
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        V latest = this.get(key);
        this.writeCache.put(key, value);
        this.deleteSet.remove(key);
        return latest;
    }

    public V remove(K key) {
        Preconditions.checkState((boolean)this.txContext.isOpen(), (Object)TX_CLOSED_ERROR);
        V latest = this.get(key);
        if (latest != null) {
            this.writeCache.remove(key);
            this.deleteSet.add(key);
        }
        return latest;
    }

    public boolean remove(K key, V value) {
        Preconditions.checkState((boolean)this.txContext.isOpen(), (Object)TX_CLOSED_ERROR);
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        V latest = this.get(key);
        if (Objects.equal(value, latest)) {
            this.remove(key);
            return true;
        }
        return false;
    }

    public boolean replace(K key, V oldValue, V newValue) {
        Preconditions.checkState((boolean)this.txContext.isOpen(), (Object)TX_CLOSED_ERROR);
        Preconditions.checkNotNull(oldValue, (Object)ERROR_NULL_VALUE);
        Preconditions.checkNotNull(newValue, (Object)ERROR_NULL_VALUE);
        V latest = this.get(key);
        if (Objects.equal(oldValue, latest)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    public V putIfAbsent(K key, V value) {
        Preconditions.checkState((boolean)this.txContext.isOpen(), (Object)TX_CLOSED_ERROR);
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        V latest = this.get(key);
        if (latest == null) {
            this.put(key, value);
        }
        return latest;
    }

    protected List<DatabaseUpdate> prepareDatabaseUpdates() {
        LinkedList updates = Lists.newLinkedList();
        this.deleteSet.forEach(key -> {
            Versioned<V> original = this.readCache.get(key);
            if (original != null) {
                updates.add(DatabaseUpdate.newBuilder().withTableName(this.name).withType(DatabaseUpdate.Type.REMOVE_IF_VERSION_MATCH).withKey((String)this.keyCache.getUnchecked(key)).withCurrentVersion(original.version()).build());
            }
        });
        this.writeCache.forEach((key, value) -> {
            Versioned<V> original = this.readCache.get(key);
            if (original == null) {
                updates.add(DatabaseUpdate.newBuilder().withTableName(this.name).withType(DatabaseUpdate.Type.PUT_IF_ABSENT).withKey((String)this.keyCache.getUnchecked(key)).withValue(this.serializer.encode(value)).build());
            } else {
                updates.add(DatabaseUpdate.newBuilder().withTableName(this.name).withType(DatabaseUpdate.Type.PUT_IF_VERSION_MATCH).withKey((String)this.keyCache.getUnchecked(key)).withCurrentVersion(original.version()).withValue(this.serializer.encode(value)).build());
            }
        });
        return updates;
    }

    protected void rollback() {
        this.readCache.clear();
        this.writeCache.clear();
        this.deleteSet.clear();
    }
}

