/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

public final class Result<V> {
    private final Status status;
    private final V value;

    public static <V> Result<V> ok(V value) {
        return new Result<V>(value, Status.OK);
    }

    public static <V> Result<V> locked() {
        return new Result<Object>(null, Status.LOCKED);
    }

    private Result(V value, Status status) {
        this.value = value;
        this.status = status;
    }

    public boolean success() {
        return this.status == Status.OK;
    }

    public Status status() {
        return this.status;
    }

    public V value() {
        return this.value;
    }

    public static enum Status {
        OK,
        LOCKED;

    }
}

