/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.core.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.ApplicationIdStore;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncAtomicCounter;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class ConsistentApplicationIdStore
implements ApplicationIdStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private AsyncAtomicCounter appIdCounter;
    private ConsistentMap<String, ApplicationId> registeredIds;
    private Map<String, ApplicationId> nameToAppIdCache = Maps.newConcurrentMap();
    private Map<Short, ApplicationId> idToAppIdCache = Maps.newConcurrentMap();
    private ScheduledExecutorService executor;
    private static final Serializer SERIALIZER = Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).nextId(300).build());

    @Activate
    public void activate() {
        this.executor = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/store/appId", (String)"retry-handler"));
        this.appIdCounter = this.storageService.atomicCounterBuilder().withName("onos-app-id-counter").withPartitionsDisabled().withRetryOnFailure().withRetryExecutor(this.executor).buildAsyncCounter();
        this.registeredIds = this.storageService.consistentMapBuilder().withName("onos-app-ids").withPartitionsDisabled().withSerializer(SERIALIZER).build();
        this.primeAppIds();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.executor.shutdown();
        this.log.info("Stopped");
    }

    public Set<ApplicationId> getAppIds() {
        this.primeAppIds();
        return ImmutableSet.copyOf(this.nameToAppIdCache.values());
    }

    public ApplicationId getAppId(Short id) {
        if (!this.idToAppIdCache.containsKey(id)) {
            this.primeAppIds();
        }
        return this.idToAppIdCache.get(id);
    }

    public ApplicationId getAppId(String name) {
        ApplicationId appId = this.nameToAppIdCache.computeIfAbsent(name, key -> {
            Versioned existingAppId = this.registeredIds.get(key);
            return existingAppId != null ? (ApplicationId)existingAppId.value() : null;
        });
        if (appId != null) {
            this.idToAppIdCache.putIfAbsent(appId.id(), appId);
        }
        return appId;
    }

    public ApplicationId registerApplication(String name) {
        ApplicationId appId = this.nameToAppIdCache.computeIfAbsent(name, key -> {
            Versioned existingAppId = this.registeredIds.get((Object)name);
            if (existingAppId == null) {
                int id = ((Long)Futures.getUnchecked((Future)this.appIdCounter.incrementAndGet())).intValue();
                DefaultApplicationId newAppId = new DefaultApplicationId(id, name);
                existingAppId = this.registeredIds.putIfAbsent((Object)name, (Object)newAppId);
                if (existingAppId != null) {
                    return (ApplicationId)existingAppId.value();
                }
                return newAppId;
            }
            return (ApplicationId)existingAppId.value();
        });
        this.idToAppIdCache.putIfAbsent(appId.id(), appId);
        return appId;
    }

    private void primeAppIds() {
        this.registeredIds.values().stream().map(Versioned::value).forEach(appId -> {
            this.nameToAppIdCache.putIfAbsent(appId.name(), (ApplicationId)appId);
            this.idToAppIdCache.putIfAbsent(appId.id(), (ApplicationId)appId);
        });
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

