/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.ecmap;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Hasher;
import org.mapdb.Serializer;
import org.onosproject.store.Timestamp;
import org.onosproject.store.ecmap.PersistentStore;
import org.onosproject.store.impl.Timestamped;
import org.onosproject.store.serializers.KryoSerializer;

class MapDbPersistentStore<K, V>
implements PersistentStore<K, V> {
    private final ExecutorService executor;
    private final KryoSerializer serializer;
    private final DB database;
    private final Map<byte[], byte[]> items;
    private final Map<byte[], byte[]> tombstones;

    MapDbPersistentStore(String filename, ExecutorService executor, KryoSerializer serializer) {
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor);
        this.serializer = (KryoSerializer)Preconditions.checkNotNull((Object)serializer);
        File databaseFile = new File(filename);
        this.database = DBMaker.newFileDB((File)databaseFile).make();
        this.items = this.database.createHashMap("items").keySerializer(Serializer.BYTE_ARRAY).valueSerializer(Serializer.BYTE_ARRAY).hasher(Hasher.BYTE_ARRAY).makeOrGet();
        this.tombstones = this.database.createHashMap("tombstones").keySerializer(Serializer.BYTE_ARRAY).valueSerializer(Serializer.BYTE_ARRAY).hasher(Hasher.BYTE_ARRAY).makeOrGet();
    }

    @Override
    public void readInto(Map<K, Timestamped<V>> items, Map<K, Timestamp> tombstones) {
        this.items.forEach((keyBytes, valueBytes) -> {
            Timestamped cfr_ignored_0 = (Timestamped)items.put((K)this.serializer.decode(keyBytes), (Timestamped<V>)this.serializer.decode(valueBytes));
        });
        this.tombstones.forEach((keyBytes, valueBytes) -> {
            Timestamp cfr_ignored_0 = (Timestamp)tombstones.put((K)this.serializer.decode(keyBytes), (Timestamp)this.serializer.decode(valueBytes));
        });
    }

    @Override
    public void put(K key, V value, Timestamp timestamp) {
        this.executor.submit(() -> this.putInternal(key, value, timestamp));
    }

    private void putInternal(K key, V value, Timestamp timestamp) {
        Timestamp removed;
        byte[] keyBytes = this.serializer.encode(key);
        byte[] removedBytes = this.tombstones.get(keyBytes);
        Timestamp timestamp2 = removed = removedBytes == null ? null : (Timestamp)this.serializer.decode(removedBytes);
        if (removed != null && removed.isNewerThan(timestamp)) {
            return;
        }
        MutableBoolean updated = new MutableBoolean(false);
        this.items.compute(keyBytes, (k, existingBytes) -> {
            Timestamped existing;
            Timestamped timestamped = existing = existingBytes == null ? null : (Timestamped)this.serializer.decode(existingBytes);
            if (existing != null && existing.isNewerThan(timestamp)) {
                updated.setFalse();
                return existingBytes;
            }
            updated.setTrue();
            return this.serializer.encode(new Timestamped<Object>(value, timestamp));
        });
        boolean success = updated.booleanValue();
        if (success && removed != null) {
            this.tombstones.remove(keyBytes, removedBytes);
        }
        this.database.commit();
    }

    @Override
    public void remove(K key, Timestamp timestamp) {
        this.executor.submit(() -> this.removeInternal(key, timestamp));
    }

    private void removeInternal(K key, Timestamp timestamp) {
        Timestamp removedTimestamp;
        byte[] keyBytes = this.serializer.encode(key);
        MutableBoolean updated = new MutableBoolean(false);
        this.items.compute(keyBytes, (k, existingBytes) -> {
            Timestamp existing;
            Timestamp timestamp2 = existing = existingBytes == null ? null : (Timestamp)this.serializer.decode(existingBytes);
            if (existing != null && existing.isNewerThan(timestamp)) {
                updated.setFalse();
                return existingBytes;
            }
            updated.setTrue();
            return null;
        });
        if (!updated.booleanValue()) {
            return;
        }
        byte[] timestampBytes = this.serializer.encode((Object)timestamp);
        byte[] removedBytes = this.tombstones.get(keyBytes);
        Timestamp timestamp2 = removedTimestamp = removedBytes == null ? null : (Timestamp)this.serializer.decode(removedBytes);
        if (removedTimestamp == null) {
            this.tombstones.putIfAbsent(keyBytes, timestampBytes);
        } else if (timestamp.isNewerThan(removedTimestamp)) {
            this.tombstones.replace(keyBytes, removedBytes, timestampBytes);
        }
        this.database.commit();
    }
}

