/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.intent.impl;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ClusterEventListener;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipEventListener;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.event.EventDeliveryService;
import org.onosproject.event.EventListener;
import org.onosproject.event.ListenerRegistry;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.PartitionEvent;
import org.onosproject.net.intent.PartitionEventListener;
import org.onosproject.net.intent.PartitionService;
import org.onosproject.store.intent.impl.PartitionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class PartitionManager
implements PartitionService {
    private static final Logger log = LoggerFactory.getLogger(PartitionManager.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LeadershipService leadershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected EventDeliveryService eventDispatcher;
    protected final AtomicBoolean rebalanceScheduled = new AtomicBoolean(false);
    static final int NUM_PARTITIONS = 14;
    private static final int BACKOFF_TIME = 2;
    private static final int CHECK_PARTITION_BALANCE_PERIOD_SEC = 10;
    private static final int RETRY_AFTER_DELAY_SEC = 5;
    private static final String ELECTION_PREFIX = "intent-partition-";
    private ListenerRegistry<PartitionEvent, PartitionEventListener> listenerRegistry;
    private LeadershipEventListener leaderListener = new InternalLeadershipListener();
    private ClusterEventListener clusterListener = new InternalClusterEventListener();
    private ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);

    @Activate
    public void activate() {
        this.leadershipService.addListener(this.leaderListener);
        this.clusterService.addListener(this.clusterListener);
        this.listenerRegistry = new ListenerRegistry();
        this.eventDispatcher.addSink(PartitionEvent.class, this.listenerRegistry);
        for (int i = 0; i < 14; ++i) {
            this.leadershipService.runForLeadership(this.getPartitionPath(i));
        }
        this.executor.scheduleAtFixedRate(() -> this.scheduleRebalance(0), 0L, 10L, TimeUnit.SECONDS);
    }

    @Deactivate
    public void deactivate() {
        this.executor.shutdownNow();
        this.eventDispatcher.removeSink(PartitionEvent.class);
        this.leadershipService.removeListener(this.leaderListener);
        this.clusterService.removeListener(this.clusterListener);
    }

    public PartitionManager withScheduledExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
        return this;
    }

    private String getPartitionPath(int i) {
        return ELECTION_PREFIX + i;
    }

    private String getPartitionPath(PartitionId id) {
        return this.getPartitionPath(id.value());
    }

    private PartitionId getPartitionForKey(Key intentKey) {
        int partition = Math.abs((int)intentKey.hash()) % 14;
        PartitionId id = new PartitionId(partition);
        return id;
    }

    public boolean isMine(Key intentKey) {
        return Objects.equals(this.leadershipService.getLeader(this.getPartitionPath(this.getPartitionForKey(intentKey))), this.clusterService.getLocalNode().id());
    }

    public NodeId getLeader(Key intentKey) {
        return this.leadershipService.getLeader(this.getPartitionPath(this.getPartitionForKey(intentKey)));
    }

    public void addListener(PartitionEventListener listener) {
        this.listenerRegistry.addListener((EventListener)listener);
    }

    public void removeListener(PartitionEventListener listener) {
        this.listenerRegistry.removeListener((EventListener)listener);
    }

    protected void doRebalance() {
        this.rebalanceScheduled.set(false);
        try {
            this.rebalance();
        }
        catch (Exception e) {
            log.warn("Exception caught during rebalance task. Will retry in 5 seconds", (Throwable)e);
            this.scheduleRebalance(5);
        }
    }

    private void rebalance() {
        int activeNodes = (int)this.clusterService.getNodes().stream().filter(node -> ControllerNode.State.ACTIVE == this.clusterService.getState(node.id())).count();
        int myShare = (int)Math.ceil(14.0 / (double)activeNodes);
        List myPartitions = this.leadershipService.getLeaderBoard().values().stream().filter(l -> this.clusterService.getLocalNode().id().equals((Object)l.leader())).filter(l -> l.topic().startsWith(ELECTION_PREFIX)).collect(Collectors.toList());
        int relinquish = myPartitions.size() - myShare;
        if (relinquish <= 0) {
            return;
        }
        for (int i = 0; i < relinquish; ++i) {
            String topic = ((Leadership)myPartitions.get(i)).topic();
            this.leadershipService.withdraw(topic);
            this.executor.schedule(() -> this.recontest(topic), 2L, TimeUnit.SECONDS);
        }
    }

    private void scheduleRebalance(int afterDelaySec) {
        if (this.rebalanceScheduled.compareAndSet(false, true)) {
            this.executor.schedule(this::doRebalance, (long)afterDelaySec, TimeUnit.SECONDS);
        }
    }

    private void recontest(String path) {
        this.leadershipService.runForLeadership(path);
    }

    protected void bindLeadershipService(LeadershipService leadershipService) {
        this.leadershipService = leadershipService;
    }

    protected void unbindLeadershipService(LeadershipService leadershipService) {
        if (this.leadershipService == leadershipService) {
            this.leadershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindEventDispatcher(EventDeliveryService eventDeliveryService) {
        this.eventDispatcher = eventDeliveryService;
    }

    protected void unbindEventDispatcher(EventDeliveryService eventDeliveryService) {
        if (this.eventDispatcher == eventDeliveryService) {
            this.eventDispatcher = null;
        }
    }

    private final class InternalClusterEventListener
    implements ClusterEventListener {
        private InternalClusterEventListener() {
        }

        public void event(ClusterEvent event) {
            PartitionManager.this.scheduleRebalance(0);
        }
    }

    private final class InternalLeadershipListener
    implements LeadershipEventListener {
        private InternalLeadershipListener() {
        }

        public void event(LeadershipEvent event) {
            Leadership leadership = (Leadership)event.subject();
            if (Objects.equals(leadership.leader(), PartitionManager.this.clusterService.getLocalNode().id()) && leadership.topic().startsWith(PartitionManager.ELECTION_PREFIX)) {
                PartitionManager.this.scheduleRebalance(0);
                PartitionManager.this.eventDispatcher.post((Event)new PartitionEvent(PartitionEvent.Type.LEADER_CHANGED, leadership.topic()));
            }
        }
    }
}

