/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.config.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigStoreDelegate;
import org.onosproject.net.config.SubjectFactory;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.config.impl.DistributedNetworkConfigStore;
import org.onosproject.store.service.TestStorageService;

public class DistributedNetworkConfigStoreTest {
    private DistributedNetworkConfigStore configStore;

    @Before
    public void setUp() {
        this.configStore = new DistributedNetworkConfigStore();
        this.configStore.storageService = new TestStorageService();
        this.configStore.setDelegate((StoreDelegate)((NetworkConfigStoreDelegate)event -> {}));
        this.configStore.activate();
    }

    @After
    public void tearDown() {
        this.configStore.deactivate();
    }

    @Test
    public void testCreateConfig() {
        this.configStore.addConfigFactory((ConfigFactory)new MockConfigFactory(null, BasicConfig.class, "config1"));
        this.configStore.createConfig((Object)"config1", BasicConfig.class);
        Assert.assertThat((Object)this.configStore.getConfigClasses((Object)"config1"), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.configStore.getSubjects(String.class, BasicConfig.class), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.configStore.getSubjects(String.class), (Matcher)Matchers.hasSize((int)1));
        BasicConfig queried = (BasicConfig)this.configStore.getConfig((Object)"config1", BasicConfig.class);
        Assert.assertThat((Object)((Object)queried), (Matcher)Matchers.notNullValue());
        this.configStore.clearConfig((Object)"config1", BasicConfig.class);
        Assert.assertThat((Object)this.configStore.getConfigClasses((Object)"config1"), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)this.configStore.getSubjects(String.class, BasicConfig.class), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)this.configStore.getSubjects(String.class), (Matcher)Matchers.hasSize((int)0));
        BasicConfig queriedAfterClear = (BasicConfig)this.configStore.getConfig((Object)"config1", BasicConfig.class);
        Assert.assertThat((Object)((Object)queriedAfterClear), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testCreateFactory() {
        MockConfigFactory mockFactory = new MockConfigFactory(null, BasicConfig.class, "config1");
        Assert.assertThat((Object)this.configStore.getConfigFactory(BasicConfig.class), (Matcher)Matchers.nullValue());
        this.configStore.addConfigFactory((ConfigFactory)mockFactory);
        Assert.assertThat((Object)this.configStore.getConfigFactory(BasicConfig.class), (Matcher)Matchers.is((Object)((Object)mockFactory)));
        this.configStore.removeConfigFactory((ConfigFactory)mockFactory);
        Assert.assertThat((Object)this.configStore.getConfigFactory(BasicConfig.class), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testApplyConfig() {
        this.configStore.addConfigFactory((ConfigFactory)new MockConfigFactory(null, BasicConfig.class, "config1"));
        this.configStore.applyConfig((Object)"config1", BasicConfig.class, (JsonNode)new ObjectMapper().createObjectNode());
        Assert.assertThat((Object)this.configStore.getConfigClasses((Object)"config1"), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.configStore.getSubjects(String.class, BasicConfig.class), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.configStore.getSubjects(String.class), (Matcher)Matchers.hasSize((int)1));
    }

    public class MockConfigFactory
    extends ConfigFactory<String, BasicConfig> {
        protected MockConfigFactory(SubjectFactory<String> subjectFactory, Class<BasicConfig> configClass, String configKey) {
            super(subjectFactory, configClass, configKey);
        }

        public BasicConfig createConfig() {
            return new BasicConfig();
        }
    }

    public class BasicConfig
    extends Config<String> {
    }
}

