/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Objects;
import junit.framework.TestCase;
import org.junit.Test;
import org.onosproject.store.consistent.impl.Match;

public class MatchTest {
    @Test
    public void testMatches() {
        Match m1 = Match.any();
        TestCase.assertTrue((boolean)m1.matches(null));
        TestCase.assertTrue((boolean)m1.matches((Object)"foo"));
        TestCase.assertTrue((boolean)m1.matches((Object)"bar"));
        Match m2 = Match.ifNull();
        TestCase.assertTrue((boolean)m2.matches(null));
        TestCase.assertFalse((boolean)m2.matches((Object)"foo"));
        Match m3 = Match.ifValue((Object)"foo");
        TestCase.assertFalse((boolean)m3.matches(null));
        TestCase.assertFalse((boolean)m3.matches((Object)"bar"));
        TestCase.assertTrue((boolean)m3.matches((Object)"foo"));
    }

    @Test
    public void testEquals() {
        Match m1 = Match.any();
        Match m2 = Match.any();
        Match m3 = Match.ifNull();
        Match m4 = Match.ifValue((Object)"bar");
        TestCase.assertEquals((Object)m1, (Object)m2);
        TestCase.assertFalse((boolean)Objects.equal((Object)m1, (Object)m3));
        TestCase.assertFalse((boolean)Objects.equal((Object)m3, (Object)m4));
    }

    @Test
    public void testMap() {
        Match m1 = Match.ifNull();
        TestCase.assertEquals((Object)m1.map(s -> "bar"), (Object)Match.ifNull());
        Match m2 = Match.ifValue((Object)"foo");
        Match m3 = m2.map(s -> "bar");
        TestCase.assertTrue((boolean)m3.matches((Object)"bar"));
    }
}

