/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.impl;

import com.google.common.testing.EqualsTester;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.util.KryoNamespace;
import org.onosproject.store.Timestamp;
import org.onosproject.store.impl.MastershipBasedTimestamp;
import org.onosproject.store.impl.Timestamped;

public class TimestampedTest {
    private static final Timestamp TS_1_1 = new MastershipBasedTimestamp(1L, 1L);
    private static final Timestamp TS_1_2 = new MastershipBasedTimestamp(1L, 2L);
    private static final Timestamp TS_2_1 = new MastershipBasedTimestamp(2L, 1L);

    @Test
    public final void testHashCode() {
        Timestamped a = new Timestamped((Object)"a", TS_1_1);
        Timestamped b = new Timestamped((Object)"b", TS_1_1);
        Assert.assertTrue((String)"value does not impact hashCode", (a.hashCode() == b.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public final void testEquals() {
        Timestamped a = new Timestamped((Object)"a", TS_1_1);
        Timestamped b = new Timestamped((Object)"b", TS_1_1);
        Assert.assertTrue((String)"value does not impact equality", (boolean)a.equals((Object)b));
        new EqualsTester().addEqualityGroup(new Object[]{new Timestamped((Object)"a", TS_1_1), new Timestamped((Object)"b", TS_1_1), new Timestamped((Object)"c", TS_1_1)}).addEqualityGroup(new Object[]{new Timestamped((Object)"a", TS_1_2), new Timestamped((Object)"b", TS_1_2), new Timestamped((Object)"c", TS_1_2)}).addEqualityGroup(new Object[]{new Timestamped((Object)"a", TS_2_1), new Timestamped((Object)"b", TS_2_1), new Timestamped((Object)"c", TS_2_1)}).testEquals();
    }

    @Test
    public final void testValue() {
        Integer n = 42;
        Timestamped tsv = new Timestamped((Object)n, TS_1_1);
        Assert.assertSame((Object)n, (Object)tsv.value());
    }

    @Test(expected=NullPointerException.class)
    public final void testValueNonNull() {
        new Timestamped(null, TS_1_1);
    }

    @Test(expected=NullPointerException.class)
    public final void testTimestampNonNull() {
        new Timestamped((Object)"Foo", null);
    }

    @Test
    public final void testIsNewer() {
        Timestamped a = new Timestamped((Object)"a", TS_1_2);
        Timestamped b = new Timestamped((Object)"b", TS_1_1);
        Assert.assertTrue((boolean)a.isNewer(b));
        Assert.assertFalse((boolean)b.isNewer(a));
    }

    @Test
    public final void testKryoSerializable() {
        ByteBuffer buffer = ByteBuffer.allocate(0x100000);
        KryoNamespace kryos = KryoNamespace.newBuilder().register(new Class[]{Timestamped.class, MastershipBasedTimestamp.class}).build();
        Timestamped original = new Timestamped((Object)"foobar", TS_1_1);
        kryos.serialize((Object)original, buffer);
        buffer.flip();
        Timestamped copy = (Timestamped)kryos.deserialize(buffer);
        new EqualsTester().addEqualityGroup(new Object[]{original, copy}).testEquals();
    }
}

