/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.intent.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.cluster.ClusterServiceAdapter;
import org.onosproject.core.IdGenerator;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.IntentTestsMocks;
import org.onosproject.net.intent.MockIdGenerator;
import org.onosproject.net.intent.PartitionServiceAdapter;
import org.onosproject.store.Timestamp;
import org.onosproject.store.intent.impl.GossipIntentStore;
import org.onosproject.store.service.TestStorageService;

public class GossipIntentStoreTest {
    private GossipIntentStore intentStore;
    private IdGenerator idGenerator;
    private HostToHostIntent.Builder builder1;

    @Before
    public void setUp() {
        this.intentStore = new GossipIntentStore();
        this.intentStore.storageService = new TestStorageService();
        this.intentStore.partitionService = new PartitionServiceAdapter();
        this.intentStore.clusterService = new ClusterServiceAdapter();
        this.idGenerator = new MockIdGenerator();
        Intent.bindIdGenerator((IdGenerator)this.idGenerator);
        this.builder1 = HostToHostIntent.builder().one(NetTestTools.hid((String)"12:34:56:78:91:ab/1")).two(NetTestTools.hid((String)"12:34:56:78:91:ac/1")).appId(NetTestTools.APP_ID);
        this.intentStore.activate();
    }

    @After
    public void cleanUp() {
        this.intentStore.deactivate();
        Intent.unbindIdGenerator((IdGenerator)this.idGenerator);
    }

    private List<IntentData> generateIntentList(int count) {
        LinkedList<IntentData> intents = new LinkedList<IntentData>();
        IntStream.rangeClosed(1, count).forEach(i -> intents.add(new IntentData((Intent)this.builder1.priority(i).build(), IntentState.INSTALLED, (Timestamp)new IntentTestsMocks.MockTimestamp(12))));
        return intents;
    }

    @Test
    public void testGetIntentCount() {
        Assert.assertThat((Object)this.intentStore.getIntentCount(), (Matcher)Matchers.is((Object)0L));
        this.generateIntentList(5).forEach(arg_0 -> ((GossipIntentStore)this.intentStore).write(arg_0));
        Assert.assertThat((Object)this.intentStore.getIntentCount(), (Matcher)Matchers.is((Object)5L));
    }

    @Test
    public void testBatchAdd() {
        Assert.assertThat((Object)this.intentStore.getIntentCount(), (Matcher)Matchers.is((Object)0L));
        List<IntentData> intents = this.generateIntentList(5);
        this.intentStore.batchWrite(intents);
        Assert.assertThat((Object)this.intentStore.getIntentCount(), (Matcher)Matchers.is((Object)5L));
    }

    @Test
    public void testAddAndWithdrawIntent() {
        HostToHostIntent intent = this.builder1.build();
        IntentData installed = new IntentData((Intent)intent, IntentState.INSTALLED, (Timestamp)new IntentTestsMocks.MockTimestamp(12));
        this.intentStore.write(installed);
        Assert.assertThat((Object)this.intentStore.getIntentCount(), (Matcher)Matchers.is((Object)1L));
        this.intentStore.getIntents().forEach(arg_0 -> GossipIntentStoreTest.lambda$testAddAndWithdrawIntent$26((Intent)intent, arg_0));
        this.intentStore.getInstallableIntents(intent.key()).forEach(arg_0 -> GossipIntentStoreTest.lambda$testAddAndWithdrawIntent$27((Intent)intent, arg_0));
        Intent queried = this.intentStore.getIntent(intent.key());
        Assert.assertThat((Object)queried, (Matcher)Matchers.is((Object)intent));
        IntentState state = this.intentStore.getIntentState(intent.key());
        Assert.assertThat((Object)state, (Matcher)Matchers.is((Object)IntentState.INSTALLED));
        IntentData dataByQuery = this.intentStore.getIntentData(intent.key());
        Assert.assertThat((Object)dataByQuery, (Matcher)Matchers.is((Object)installed));
        Iterable dataIteratorByTime = this.intentStore.getIntentData(true, 10L);
        Assert.assertThat((Object)dataIteratorByTime.iterator().hasNext(), (Matcher)Matchers.is((Object)true));
        dataIteratorByTime.forEach(data -> Assert.assertThat((Object)data, (Matcher)Matchers.is((Object)installed)));
        Iterable dataIteratorAll = this.intentStore.getIntentData(false, 0L);
        Assert.assertThat((Object)dataIteratorAll.iterator().hasNext(), (Matcher)Matchers.is((Object)true));
        dataIteratorAll.forEach(data -> Assert.assertThat((Object)data, (Matcher)Matchers.is((Object)installed)));
        IntentData purge = new IntentData((Intent)intent, IntentState.PURGE_REQ, (Timestamp)new IntentTestsMocks.MockTimestamp(12));
        this.intentStore.write(purge);
        Assert.assertThat((Object)this.intentStore.getIntentCount(), (Matcher)Matchers.is((Object)0L));
        Intent queriedAfterWithdrawal = this.intentStore.getIntent(intent.key());
        Assert.assertThat((Object)queriedAfterWithdrawal, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testPending() {
        HostToHostIntent intent = this.builder1.build();
        IntentData installed = new IntentData((Intent)intent, IntentState.INSTALLED, (Timestamp)new IntentTestsMocks.MockTimestamp(11));
        this.intentStore.addPending(installed);
        Iterable pendingIntentIteratorAll = this.intentStore.getPending();
        Assert.assertThat((Object)pendingIntentIteratorAll.iterator().hasNext(), (Matcher)Matchers.is((Object)true));
        pendingIntentIteratorAll.forEach(arg_0 -> GossipIntentStoreTest.lambda$testPending$30((Intent)intent, arg_0));
        Iterable pendingDataIteratorAll = this.intentStore.getPendingData();
        Assert.assertThat((Object)pendingDataIteratorAll.iterator().hasNext(), (Matcher)Matchers.is((Object)true));
        pendingDataIteratorAll.forEach(data -> Assert.assertThat((Object)data, (Matcher)Matchers.is((Object)installed)));
        Iterable pendingDataIteratorSelected = this.intentStore.getPendingData(true, 10L);
        Assert.assertThat((Object)pendingDataIteratorSelected.iterator().hasNext(), (Matcher)Matchers.is((Object)true));
        pendingDataIteratorSelected.forEach(data -> Assert.assertThat((Object)data, (Matcher)Matchers.is((Object)installed)));
        Iterable pendingDataIteratorAllFromTimestamp = this.intentStore.getPendingData(false, 0L);
        Assert.assertThat((Object)pendingDataIteratorAllFromTimestamp.iterator().hasNext(), (Matcher)Matchers.is((Object)true));
        pendingDataIteratorSelected.forEach(data -> Assert.assertThat((Object)data, (Matcher)Matchers.is((Object)installed)));
    }

    private static /* synthetic */ void lambda$testPending$30(Intent intent, Intent data) {
        Assert.assertThat((Object)data, (Matcher)Matchers.is((Object)intent));
    }

    private static /* synthetic */ void lambda$testAddAndWithdrawIntent$27(Intent intent, Intent item) {
        Assert.assertThat((Object)item, (Matcher)Matchers.is((Object)intent));
    }

    private static /* synthetic */ void lambda$testAddAndWithdrawIntent$26(Intent intent, Intent item) {
        Assert.assertThat((Object)item, (Matcher)Matchers.is((Object)intent));
    }
}

