/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.intent.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.junit.NullScheduledExecutor;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterServiceAdapter;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipEventListener;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.LeadershipServiceAdapter;
import org.onosproject.cluster.NodeId;
import org.onosproject.common.event.impl.TestEventDispatcher;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.net.intent.Key;
import org.onosproject.store.intent.impl.PartitionManager;

public class PartitionManagerTest {
    private final LeadershipEvent event = new LeadershipEvent(LeadershipEvent.Type.LEADER_ELECTED, new Leadership("intent-partition-0", MY_NODE_ID, 0L, 0L));
    private static final NodeId MY_NODE_ID = new NodeId("local");
    private static final NodeId OTHER_NODE_ID = new NodeId("other");
    private static final NodeId INACTIVE_NODE_ID = new NodeId("inactive");
    private static final String ELECTION_PREFIX = "intent-partition-";
    private LeadershipService leadershipService;
    private LeadershipEventListener leaderListener;
    private PartitionManager partitionManager;

    @Before
    public void setUp() {
        this.leadershipService = (LeadershipService)EasyMock.createMock(LeadershipService.class);
        this.leadershipService.addListener((EventListener)EasyMock.anyObject(LeadershipEventListener.class));
        EasyMock.expectLastCall().andDelegateTo((Object)new TestLeadershipService());
        for (int i = 0; i < 14; ++i) {
            EasyMock.expect((Object)this.leadershipService.runForLeadership(ELECTION_PREFIX + i)).andReturn(CompletableFuture.completedFuture(null)).times(1);
        }
        this.partitionManager = new PartitionManager().withScheduledExecutor((ScheduledExecutorService)new NullScheduledExecutor());
        this.partitionManager.clusterService = new TestClusterService();
        this.partitionManager.leadershipService = this.leadershipService;
        this.partitionManager.eventDispatcher = new TestEventDispatcher();
    }

    private void setUpLeadershipService(int numMine) {
        int i;
        HashMap<String, Leadership> leaderBoard = new HashMap<String, Leadership>();
        for (i = 0; i < numMine; ++i) {
            EasyMock.expect((Object)this.leadershipService.getLeader(ELECTION_PREFIX + i)).andReturn((Object)MY_NODE_ID).anyTimes();
            leaderBoard.put(ELECTION_PREFIX + i, new Leadership(ELECTION_PREFIX + i, MY_NODE_ID, 0L, 0L));
        }
        for (i = numMine; i < 14; ++i) {
            EasyMock.expect((Object)this.leadershipService.getLeader(ELECTION_PREFIX + i)).andReturn((Object)OTHER_NODE_ID).anyTimes();
            leaderBoard.put(ELECTION_PREFIX + i, new Leadership(ELECTION_PREFIX + i, OTHER_NODE_ID, 0L, 0L));
        }
        EasyMock.expect((Object)this.leadershipService.getLeaderBoard()).andReturn(leaderBoard).anyTimes();
    }

    @Test
    public void testActivate() {
        EasyMock.reset((Object[])new Object[]{this.leadershipService});
        this.leadershipService.addListener((EventListener)EasyMock.anyObject(LeadershipEventListener.class));
        for (int i = 0; i < 14; ++i) {
            EasyMock.expect((Object)this.leadershipService.runForLeadership(ELECTION_PREFIX + i)).andReturn(CompletableFuture.completedFuture(null)).times(1);
        }
        EasyMock.replay((Object[])new Object[]{this.leadershipService});
        this.partitionManager.activate();
        EasyMock.verify((Object[])new Object[]{this.leadershipService});
    }

    @Test
    public void testIsMine() {
        this.setUpLeadershipService(1);
        EasyMock.replay((Object[])new Object[]{this.leadershipService});
        ControllableHashKey myKey = new ControllableHashKey(0L);
        ControllableHashKey notMyKey = new ControllableHashKey(1L);
        Assert.assertTrue((boolean)this.partitionManager.isMine((Key)myKey));
        TestCase.assertFalse((boolean)this.partitionManager.isMine((Key)notMyKey));
        EasyMock.reset((Object[])new Object[]{this.leadershipService});
        this.setUpLeadershipService(4);
        EasyMock.replay((Object[])new Object[]{this.leadershipService});
        Assert.assertTrue((boolean)this.partitionManager.isMine((Key)myKey));
        Assert.assertTrue((boolean)this.partitionManager.isMine((Key)notMyKey));
        TestCase.assertFalse((boolean)this.partitionManager.isMine((Key)new ControllableHashKey(4L)));
    }

    @Test
    public void testRebalanceScheduling() {
        this.setUpLeadershipService(14);
        EasyMock.replay((Object[])new Object[]{this.leadershipService});
        this.partitionManager.activate();
        this.leaderListener.event((Event)this.event);
        Assert.assertTrue((boolean)this.partitionManager.rebalanceScheduled.get());
        EasyMock.verify((Object[])new Object[]{this.leadershipService});
    }

    @Test
    public void testRebalance() {
        this.setUpLeadershipService(14);
        EasyMock.expect((Object)this.leadershipService.withdraw(EasyMock.anyString())).andReturn(CompletableFuture.completedFuture(null)).times(7);
        EasyMock.replay((Object[])new Object[]{this.leadershipService});
        this.partitionManager.activate();
        this.partitionManager.doRebalance();
        EasyMock.verify((Object[])new Object[]{this.leadershipService});
    }

    @Test
    public void testNoRebalance() {
        this.setUpLeadershipService(7);
        EasyMock.replay((Object[])new Object[]{this.leadershipService});
        this.partitionManager.activate();
        this.partitionManager.doRebalance();
        EasyMock.verify((Object[])new Object[]{this.leadershipService});
        EasyMock.reset((Object[])new Object[]{this.leadershipService});
        this.setUpLeadershipService(6);
        EasyMock.replay((Object[])new Object[]{this.leadershipService});
        this.partitionManager.doRebalance();
        EasyMock.verify((Object[])new Object[]{this.leadershipService});
    }

    static /* synthetic */ NodeId access$100() {
        return MY_NODE_ID;
    }

    static /* synthetic */ NodeId access$200() {
        return OTHER_NODE_ID;
    }

    private class ControllableHashKey
    extends Key {
        protected ControllableHashKey(long hash) {
            super(hash);
        }

        public int hashCode() {
            return Objects.hash(this.hash());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ControllableHashKey)) {
                return false;
            }
            ControllableHashKey that = (ControllableHashKey)((Object)obj);
            return Objects.equals(this.hash(), that.hash());
        }
    }

    private class TestClusterService
    extends ClusterServiceAdapter {
        private final ControllerNode self = new DefaultControllerNode(PartitionManagerTest.access$100(), IpAddress.valueOf((int)1));
        private final ControllerNode otherNode = new DefaultControllerNode(PartitionManagerTest.access$200(), IpAddress.valueOf((int)2));
        private final ControllerNode inactiveNode = new DefaultControllerNode(PartitionManagerTest.access$300(), IpAddress.valueOf((int)3));
        Set<ControllerNode> nodes = new HashSet<ControllerNode>();

        public TestClusterService() {
            this.nodes.add(this.self);
            this.nodes.add(this.otherNode);
            this.nodes.add(this.inactiveNode);
        }

        public ControllerNode getLocalNode() {
            return this.self;
        }

        public Set<ControllerNode> getNodes() {
            return this.nodes;
        }

        public ControllerNode getNode(NodeId nodeId) {
            return this.nodes.stream().filter(c -> c.id().equals((Object)nodeId)).findFirst().get();
        }

        public ControllerNode.State getState(NodeId nodeId) {
            return nodeId.equals((Object)INACTIVE_NODE_ID) ? ControllerNode.State.INACTIVE : ControllerNode.State.ACTIVE;
        }
    }

    public class TestLeadershipService
    extends LeadershipServiceAdapter {
        public void addListener(LeadershipEventListener listener) {
            PartitionManagerTest.this.leaderListener = listener;
        }
    }
}

