/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.impl;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.cluster.ControllerNode;

public final class NodeInfo {
    private final String id;
    private final String ip;
    private final int tcpPort;

    private NodeInfo(String id, String ip, int port) {
        this.id = id;
        this.ip = ip;
        this.tcpPort = port;
    }

    private NodeInfo() {
        this.id = null;
        this.ip = null;
        this.tcpPort = 0;
    }

    public static NodeInfo from(String id, String ip, int port) {
        NodeInfo node = new NodeInfo(id, ip, port);
        return node;
    }

    public static NodeInfo of(ControllerNode node) {
        return NodeInfo.from(node.id().toString(), node.ip().toString(), node.tcpPort());
    }

    public String getId() {
        return this.id;
    }

    public String getIp() {
        return this.ip;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.ip, this.tcpPort);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NodeInfo) {
            NodeInfo that = (NodeInfo)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.ip, that.ip) && Objects.equals(this.tcpPort, that.tcpPort);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("ip", (Object)this.ip).add("tcpPort", this.tcpPort).toString();
    }
}

