/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.messaging.impl;

import com.google.common.base.Strings;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.netty.NettyMessaging;
import org.onosproject.cluster.ClusterDefinitionService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.store.cluster.messaging.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class NettyMessagingManager
extends NettyMessaging {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final short MIN_KS_LENGTH = 6;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterDefinitionService clusterDefinitionService;

    @Activate
    public void activate() throws Exception {
        ControllerNode localNode = this.clusterDefinitionService.localNode();
        this.getTLSParameters();
        super.start(new Endpoint(localNode.ip(), localNode.tcpPort()));
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() throws Exception {
        super.stop();
        this.log.info("Stopped");
    }

    private void getTLSParameters() {
        String tempString = System.getProperty("enableNettyTLS");
        this.enableNettyTLS = Strings.isNullOrEmpty((String)tempString) ? false : Boolean.parseBoolean(tempString);
        this.log.info("enableNettyTLS = {}", (Object)this.enableNettyTLS);
        if (this.enableNettyTLS) {
            this.ksLocation = System.getProperty("javax.net.ssl.keyStore");
            if (Strings.isNullOrEmpty((String)this.ksLocation)) {
                this.enableNettyTLS = false;
                return;
            }
            this.tsLocation = System.getProperty("javax.net.ssl.trustStore");
            if (Strings.isNullOrEmpty((String)this.tsLocation)) {
                this.enableNettyTLS = false;
                return;
            }
            this.ksPwd = System.getProperty("javax.net.ssl.keyStorePassword").toCharArray();
            if (6 > this.ksPwd.length) {
                this.enableNettyTLS = false;
                return;
            }
            this.tsPwd = System.getProperty("javax.net.ssl.trustStorePassword").toCharArray();
            if (6 > this.tsPwd.length) {
                this.enableNettyTLS = false;
                return;
            }
        }
    }

    protected void bindClusterDefinitionService(ClusterDefinitionService clusterDefinitionService) {
        this.clusterDefinitionService = clusterDefinitionService;
    }

    protected void unbindClusterDefinitionService(ClusterDefinitionService clusterDefinitionService) {
        if (this.clusterDefinitionService == clusterDefinitionService) {
            this.clusterDefinitionService = null;
        }
    }
}

