/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.config.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.event.Event;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigStore;
import org.onosproject.net.config.NetworkConfigStoreDelegate;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedNetworkConfigStore
extends AbstractStore<NetworkConfigEvent, NetworkConfigStoreDelegate>
implements NetworkConfigStore {
    private static final int MAX_BACKOFF = 10;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private ConsistentMap<ConfigKey, JsonNode> configs;
    private final Map<String, ConfigFactory> factoriesByConfig = Maps.newConcurrentMap();
    private final ObjectMapper mapper = new ObjectMapper();
    private final ConfigApplyDelegate applyDelegate = new InternalApplyDelegate();
    private final MapEventListener<ConfigKey, JsonNode> listener = new InternalMapListener();

    @Activate
    public void activate() {
        KryoNamespace.Builder kryoBuilder = new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{ConfigKey.class, ObjectNode.class, ArrayNode.class, JsonNodeFactory.class, LinkedHashMap.class, TextNode.class, BooleanNode.class, LongNode.class, DoubleNode.class, ShortNode.class, IntNode.class});
        this.configs = this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)kryoBuilder.build())).withName("onos-network-configs").withRelaxedReadConsistency().build();
        this.configs.addListener(this.listener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.configs.removeListener(this.listener);
        this.log.info("Stopped");
    }

    public void addConfigFactory(ConfigFactory configFactory) {
        this.factoriesByConfig.put(configFactory.configClass().getName(), configFactory);
        this.notifyDelegate((Event)new NetworkConfigEvent(NetworkConfigEvent.Type.CONFIG_REGISTERED, (Object)configFactory.configKey(), configFactory.configClass()));
    }

    public void removeConfigFactory(ConfigFactory configFactory) {
        this.factoriesByConfig.remove(configFactory.configClass().getName());
        this.notifyDelegate((Event)new NetworkConfigEvent(NetworkConfigEvent.Type.CONFIG_UNREGISTERED, (Object)configFactory.configKey(), configFactory.configClass()));
    }

    public <S, C extends Config<S>> ConfigFactory<S, C> getConfigFactory(Class<C> configClass) {
        return this.factoriesByConfig.get(configClass.getName());
    }

    public <S> Set<S> getSubjects(Class<S> subjectClass) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.configs.keySet().forEach(k -> {
            if (subjectClass.isInstance(k.subject)) {
                builder.add(k.subject);
            }
        });
        return builder.build();
    }

    public <S, C extends Config<S>> Set<S> getSubjects(Class<S> subjectClass, Class<C> configClass) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        String cName = configClass.getName();
        this.configs.keySet().forEach(k -> {
            if (subjectClass.isInstance(k.subject) && cName.equals(k.configClass)) {
                builder.add(k.subject);
            }
        });
        return builder.build();
    }

    public <S> Set<Class<? extends Config<S>>> getConfigClasses(S subject) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.configs.keySet().forEach(k -> {
            if (Objects.equals(subject, k.subject) && this.delegate != null) {
                builder.add((Object)this.factoriesByConfig.get(k.configClass).configClass());
            }
        });
        return builder.build();
    }

    public <S, T extends Config<S>> T getConfig(S subject, Class<T> configClass) {
        Versioned json = (Versioned)Tools.retryable(arg_0 -> this.configs.get(arg_0), ConsistentMapException.class, (int)1, (int)10).apply(DistributedNetworkConfigStore.key(subject, configClass));
        return json != null ? (T)this.createConfig(subject, configClass, (JsonNode)json.value()) : null;
    }

    public <S, C extends Config<S>> C createConfig(S subject, Class<C> configClass) {
        ConfigFactory factory = this.getConfigFactory(configClass);
        Versioned json = this.configs.computeIfAbsent((Object)DistributedNetworkConfigStore.key(subject, configClass), k -> factory.isList() ? this.mapper.createArrayNode() : this.mapper.createObjectNode());
        return this.createConfig(subject, configClass, (JsonNode)json.value());
    }

    public <S, C extends Config<S>> C applyConfig(S subject, Class<C> configClass, JsonNode json) {
        return this.createConfig(subject, configClass, (JsonNode)this.configs.putAndGet((Object)DistributedNetworkConfigStore.key(subject, configClass), (Object)json).value());
    }

    public <S, C extends Config<S>> void clearConfig(S subject, Class<C> configClass) {
        this.configs.remove((Object)DistributedNetworkConfigStore.key(subject, configClass));
    }

    private <S, C extends Config<S>> C createConfig(S subject, Class<C> configClass, JsonNode json) {
        ConfigFactory factory;
        if (json != null && (factory = this.factoriesByConfig.get(configClass.getName())) != null) {
            Config config = factory.createConfig();
            config.init(subject, factory.configKey(), json, this.mapper, this.applyDelegate);
            return (C)config;
        }
        return null;
    }

    private static ConfigKey key(Object subject, Class<?> configClass) {
        return new ConfigKey(subject, configClass);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class InternalMapListener
    implements MapEventListener<ConfigKey, JsonNode> {
        private InternalMapListener() {
        }

        public void event(MapEvent<ConfigKey, JsonNode> event) {
            NetworkConfigEvent.Type type;
            switch (event.type()) {
                case INSERT: {
                    type = NetworkConfigEvent.Type.CONFIG_ADDED;
                    break;
                }
                case UPDATE: {
                    type = NetworkConfigEvent.Type.CONFIG_UPDATED;
                    break;
                }
                default: {
                    type = NetworkConfigEvent.Type.CONFIG_REMOVED;
                }
            }
            ConfigFactory factory = (ConfigFactory)DistributedNetworkConfigStore.this.factoriesByConfig.get(((ConfigKey)event.key()).configClass);
            if (factory != null) {
                DistributedNetworkConfigStore.this.notifyDelegate((Event)new NetworkConfigEvent(type, ((ConfigKey)event.key()).subject, factory.configClass()));
            }
        }
    }

    private static final class ConfigKey {
        final Object subject;
        final String configClass;

        private ConfigKey(Object subject, Class<?> configClass) {
            this.subject = subject;
            this.configClass = configClass.getName();
        }

        public int hashCode() {
            return Objects.hash(this.subject, this.configClass);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ConfigKey) {
                ConfigKey other = (ConfigKey)obj;
                return Objects.equals(this.subject, other.subject) && Objects.equals(this.configClass, other.configClass);
            }
            return false;
        }
    }

    private class InternalApplyDelegate
    implements ConfigApplyDelegate {
        private InternalApplyDelegate() {
        }

        public void onApply(Config config) {
            DistributedNetworkConfigStore.this.configs.put((Object)DistributedNetworkConfigStore.key(config.subject(), config.getClass()), (Object)config.node());
        }
    }
}

