/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.onosproject.store.consistent.impl.UpdateResult;

public final class CommitResponse {
    private boolean success;
    private List<UpdateResult<String, byte[]>> updates;

    public static CommitResponse success(List<UpdateResult<String, byte[]>> updates) {
        return new CommitResponse(true, updates);
    }

    public static CommitResponse failure() {
        return new CommitResponse(false, Collections.emptyList());
    }

    private CommitResponse(boolean success, List<UpdateResult<String, byte[]>> updates) {
        this.success = success;
        this.updates = ImmutableList.copyOf(updates);
    }

    public boolean success() {
        return this.success;
    }

    public List<UpdateResult<String, byte[]>> updates() {
        return this.updates;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("success", this.success).add("udpates", this.updates).toString();
    }
}

