/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.DefaultAsyncAtomicCounter;
import org.onosproject.store.service.AsyncAtomicCounter;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.StorageException;

public class DefaultAtomicCounter
implements AtomicCounter {
    private static final int OPERATION_TIMEOUT_MILLIS = 5000;
    private final AsyncAtomicCounter asyncCounter;

    public DefaultAtomicCounter(String name, Database database, boolean meteringEnabled) {
        this.asyncCounter = new DefaultAsyncAtomicCounter(name, database, meteringEnabled);
    }

    public long incrementAndGet() {
        return (Long)DefaultAtomicCounter.complete(this.asyncCounter.incrementAndGet());
    }

    public long getAndIncrement() {
        return (Long)DefaultAtomicCounter.complete(this.asyncCounter.getAndIncrement());
    }

    public long getAndAdd(long delta) {
        return (Long)DefaultAtomicCounter.complete(this.asyncCounter.getAndAdd(delta));
    }

    public long addAndGet(long delta) {
        return (Long)DefaultAtomicCounter.complete(this.asyncCounter.getAndAdd(delta));
    }

    public long get() {
        return (Long)DefaultAtomicCounter.complete(this.asyncCounter.get());
    }

    private static <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StorageException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new StorageException.Timeout();
        }
        catch (ExecutionException e) {
            throw new StorageException(e.getCause());
        }
    }
}

