/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.onosproject.store.consistent.impl.MeteringAgent;
import org.onosproject.store.service.AtomicValue;
import org.onosproject.store.service.AtomicValueEvent;
import org.onosproject.store.service.AtomicValueEventListener;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.Versioned;

public class DefaultAtomicValue<V>
implements AtomicValue<V> {
    private final Set<AtomicValueEventListener<V>> listeners = new CopyOnWriteArraySet<AtomicValueEventListener<V>>();
    private final ConsistentMap<String, byte[]> valueMap;
    private final String name;
    private final Serializer serializer;
    private final MapEventListener<String, byte[]> mapEventListener = new InternalMapEventListener();
    private final MeteringAgent monitor;
    private static final String COMPONENT_NAME = "atomicValue";
    private static final String GET = "get";
    private static final String GET_AND_SET = "getAndSet";
    private static final String COMPARE_AND_SET = "compareAndSet";

    public DefaultAtomicValue(ConsistentMap<String, byte[]> valueMap, String name, boolean meteringEnabled, Serializer serializer) {
        this.valueMap = valueMap;
        this.name = name;
        this.serializer = serializer;
        this.monitor = new MeteringAgent(COMPONENT_NAME, name, meteringEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareAndSet(V expect, V update) {
        MeteringAgent.Context newTimer = this.monitor.startTimer(COMPARE_AND_SET);
        try {
            if (expect == null) {
                if (update == null) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = this.valueMap.putIfAbsent((Object)this.name, (Object)this.serializer.encode(update)) == null;
                return bl;
            }
            if (update == null) {
                boolean bl = this.valueMap.remove((Object)this.name, (Object)this.serializer.encode(expect));
                return bl;
            }
            boolean bl = this.valueMap.replace((Object)this.name, (Object)this.serializer.encode(expect), (Object)this.serializer.encode(update));
            return bl;
        }
        finally {
            newTimer.stop(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get() {
        MeteringAgent.Context newTimer = this.monitor.startTimer(GET);
        try {
            Versioned rawValue = this.valueMap.get((Object)this.name);
            Object object = rawValue == null ? null : this.serializer.decode((byte[])rawValue.value());
            return (V)object;
        }
        finally {
            newTimer.stop(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getAndSet(V value) {
        MeteringAgent.Context newTimer = this.monitor.startTimer(GET_AND_SET);
        try {
            Versioned previousValue = value == null ? this.valueMap.remove((Object)this.name) : this.valueMap.put((Object)this.name, (Object)this.serializer.encode(value));
            Object object = previousValue == null ? null : this.serializer.decode((byte[])previousValue.value());
            return (V)object;
        }
        finally {
            newTimer.stop(null);
        }
    }

    public void set(V value) {
        this.getAndSet(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AtomicValueEventListener<V> listener) {
        Set<AtomicValueEventListener<V>> set = this.listeners;
        synchronized (set) {
            if (this.listeners.add(listener) && this.listeners.size() == 1) {
                this.valueMap.addListener(this.mapEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(AtomicValueEventListener<V> listener) {
        Set<AtomicValueEventListener<V>> set = this.listeners;
        synchronized (set) {
            if (this.listeners.remove(listener) && this.listeners.size() == 0) {
                this.valueMap.removeListener(this.mapEventListener);
            }
        }
    }

    private class InternalMapEventListener
    implements MapEventListener<String, byte[]> {
        private InternalMapEventListener() {
        }

        public void event(MapEvent<String, byte[]> mapEvent) {
            Object newValue = mapEvent.type() == MapEvent.Type.REMOVE ? null : DefaultAtomicValue.this.serializer.decode((byte[])mapEvent.value().value());
            AtomicValueEvent atomicValueEvent = new AtomicValueEvent(DefaultAtomicValue.this.name, AtomicValueEvent.Type.UPDATE, newValue);
            DefaultAtomicValue.this.listeners.forEach(l -> l.event(atomicValueEvent));
        }
    }
}

