/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import net.kuujo.copycat.state.Initializer;
import net.kuujo.copycat.state.StateContext;
import org.onosproject.store.consistent.impl.CommitResponse;
import org.onosproject.store.consistent.impl.DatabaseState;
import org.onosproject.store.consistent.impl.Match;
import org.onosproject.store.consistent.impl.Result;
import org.onosproject.store.consistent.impl.UpdateResult;
import org.onosproject.store.service.DatabaseUpdate;
import org.onosproject.store.service.Transaction;
import org.onosproject.store.service.Versioned;

public class DefaultDatabaseState
implements DatabaseState<String, byte[]> {
    private Long nextVersion;
    private Map<String, AtomicLong> counters;
    private Map<String, Map<String, Versioned<byte[]>>> maps;
    private Map<String, Queue<byte[]>> queues;
    private Map<String, Map<String, Update>> locks;

    @Override
    @Initializer
    public void init(StateContext<DatabaseState<String, byte[]>> context) {
        this.counters = (Map)context.get("counters");
        if (this.counters == null) {
            this.counters = Maps.newConcurrentMap();
            context.put("counters", this.counters);
        }
        this.maps = (Map)context.get("maps");
        if (this.maps == null) {
            this.maps = Maps.newConcurrentMap();
            context.put("maps", this.maps);
        }
        this.locks = (Map)context.get("locks");
        if (this.locks == null) {
            this.locks = Maps.newConcurrentMap();
            context.put("locks", this.locks);
        }
        this.queues = (Map)context.get("queues");
        if (this.queues == null) {
            this.queues = Maps.newConcurrentMap();
            context.put("queues", this.queues);
        }
        this.nextVersion = (Long)context.get("nextVersion");
        if (this.nextVersion == null) {
            this.nextVersion = 0L;
            context.put("nextVersion", (Object)this.nextVersion);
        }
    }

    @Override
    public Set<String> maps() {
        return ImmutableSet.copyOf(this.maps.keySet());
    }

    @Override
    public Map<String, Long> counters() {
        HashMap counterMap = Maps.newHashMap();
        this.counters.forEach((k, v) -> counterMap.put(k, v.get()));
        return counterMap;
    }

    @Override
    public int mapSize(String mapName) {
        return this.getMap(mapName).size();
    }

    @Override
    public boolean mapIsEmpty(String mapName) {
        return this.getMap(mapName).isEmpty();
    }

    @Override
    public boolean mapContainsKey(String mapName, String key) {
        return this.getMap(mapName).containsKey(key);
    }

    @Override
    public boolean mapContainsValue(String mapName, byte[] value) {
        return this.getMap(mapName).values().stream().anyMatch(v -> Arrays.equals((byte[])v.value(), value));
    }

    @Override
    public Versioned<byte[]> mapGet(String mapName, String key) {
        return this.getMap(mapName).get(key);
    }

    @Override
    public Result<UpdateResult<String, byte[]>> mapUpdate(String mapName, String key, Match<byte[]> valueMatch, Match<Long> versionMatch, byte[] value) {
        if (this.isLockedForUpdates(mapName, key)) {
            return Result.locked();
        }
        Versioned<byte[]> currentValue = this.getMap(mapName).get(key);
        if (!valueMatch.matches(currentValue == null ? null : (byte[])currentValue.value()) || !versionMatch.matches(currentValue == null ? null : Long.valueOf(currentValue.version()))) {
            return Result.ok(new UpdateResult<String, byte[]>(false, mapName, key, currentValue, currentValue));
        }
        if (value == null) {
            if (currentValue == null) {
                return Result.ok(new UpdateResult(false, mapName, key, null, null));
            }
            this.getMap(mapName).remove(key);
            return Result.ok(new UpdateResult<String, byte[]>(true, mapName, key, currentValue, null));
        }
        this.nextVersion = this.nextVersion + 1L;
        Versioned newValue = new Versioned((Object)value, this.nextVersion.longValue());
        this.getMap(mapName).put(key, (Versioned<byte[]>)newValue);
        return Result.ok(new UpdateResult<String, byte[]>(true, mapName, key, currentValue, newValue));
    }

    @Override
    public Result<Void> mapClear(String mapName) {
        if (this.areTransactionsInProgress(mapName)) {
            return Result.locked();
        }
        this.getMap(mapName).clear();
        return Result.ok(null);
    }

    @Override
    public Set<String> mapKeySet(String mapName) {
        return ImmutableSet.copyOf(this.getMap(mapName).keySet());
    }

    @Override
    public Collection<Versioned<byte[]>> mapValues(String mapName) {
        return ImmutableList.copyOf(this.getMap(mapName).values());
    }

    @Override
    public Set<Map.Entry<String, Versioned<byte[]>>> mapEntrySet(String mapName) {
        return ImmutableSet.copyOf((Collection)this.getMap(mapName).entrySet().stream().map(entry -> Maps.immutableEntry(entry.getKey(), entry.getValue())).collect(Collectors.toSet()));
    }

    @Override
    public Long counterAddAndGet(String counterName, long delta) {
        return this.getCounter(counterName).addAndGet(delta);
    }

    @Override
    public Long counterGetAndAdd(String counterName, long delta) {
        return this.getCounter(counterName).getAndAdd(delta);
    }

    @Override
    public Long counterGet(String counterName) {
        return this.getCounter(counterName).get();
    }

    @Override
    public Long queueSize(String queueName) {
        return this.getQueue(queueName).size();
    }

    @Override
    public byte[] queuePeek(String queueName) {
        return this.getQueue(queueName).peek();
    }

    @Override
    public byte[] queuePop(String queueName) {
        return this.getQueue(queueName).poll();
    }

    @Override
    public void queuePush(String queueName, byte[] entry) {
        this.getQueue(queueName).offer(entry);
    }

    @Override
    public CommitResponse prepareAndCommit(Transaction transaction) {
        if (this.prepare(transaction)) {
            return this.commit(transaction);
        }
        return CommitResponse.failure();
    }

    @Override
    public boolean prepare(Transaction transaction) {
        if (transaction.updates().stream().anyMatch(update -> this.isLockedByAnotherTransaction(update.mapName(), update.key(), transaction.id()))) {
            return false;
        }
        if (transaction.updates().stream().allMatch(this::isUpdatePossible)) {
            transaction.updates().forEach(update -> this.doProvisionalUpdate((DatabaseUpdate)update, transaction.id()));
            return true;
        }
        return false;
    }

    @Override
    public CommitResponse commit(Transaction transaction) {
        return CommitResponse.success(Lists.transform((List)transaction.updates(), update -> this.commitProvisionalUpdate((DatabaseUpdate)update, transaction.id())));
    }

    @Override
    public boolean rollback(Transaction transaction) {
        transaction.updates().forEach(update -> this.undoProvisionalUpdate((DatabaseUpdate)update, transaction.id()));
        return true;
    }

    private Map<String, Versioned<byte[]>> getMap(String mapName) {
        return this.maps.computeIfAbsent(mapName, name -> Maps.newConcurrentMap());
    }

    private Map<String, Update> getLockMap(String mapName) {
        return this.locks.computeIfAbsent(mapName, name -> Maps.newConcurrentMap());
    }

    private AtomicLong getCounter(String counterName) {
        return this.counters.computeIfAbsent(counterName, name -> new AtomicLong(0L));
    }

    private Queue<byte[]> getQueue(String queueName) {
        return this.queues.computeIfAbsent(queueName, name -> new LinkedList());
    }

    private boolean isUpdatePossible(DatabaseUpdate update) {
        Versioned<byte[]> existingEntry = this.mapGet(update.mapName(), update.key());
        switch (update.type()) {
            case PUT: 
            case REMOVE: {
                return true;
            }
            case PUT_IF_ABSENT: {
                return existingEntry == null;
            }
            case PUT_IF_VERSION_MATCH: {
                return existingEntry != null && existingEntry.version() == update.currentVersion();
            }
            case PUT_IF_VALUE_MATCH: {
                return existingEntry != null && Arrays.equals((byte[])existingEntry.value(), update.currentValue());
            }
            case REMOVE_IF_VERSION_MATCH: {
                return existingEntry == null || existingEntry.version() == update.currentVersion();
            }
            case REMOVE_IF_VALUE_MATCH: {
                return existingEntry == null || Arrays.equals((byte[])existingEntry.value(), update.currentValue());
            }
        }
        throw new IllegalStateException("Unsupported type: " + update.type());
    }

    private void doProvisionalUpdate(DatabaseUpdate update, long transactionId) {
        Map<String, Update> lockMap = this.getLockMap(update.mapName());
        switch (update.type()) {
            case PUT: 
            case PUT_IF_ABSENT: 
            case PUT_IF_VERSION_MATCH: 
            case PUT_IF_VALUE_MATCH: {
                lockMap.put(update.key(), new Update(transactionId, update.value()));
                break;
            }
            case REMOVE: 
            case REMOVE_IF_VERSION_MATCH: 
            case REMOVE_IF_VALUE_MATCH: {
                lockMap.put(update.key(), new Update(transactionId, null));
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported type: " + update.type());
            }
        }
    }

    private UpdateResult<String, byte[]> commitProvisionalUpdate(DatabaseUpdate update, long transactionId) {
        String mapName = update.mapName();
        String key = update.key();
        Update provisionalUpdate = this.getLockMap(mapName).get(key);
        if (!Objects.equal((Object)transactionId, (Object)provisionalUpdate.transactionId())) {
            throw new IllegalStateException("Invalid transaction Id");
        }
        this.getLockMap(mapName).remove(key);
        return this.mapUpdate(mapName, key, Match.any(), Match.any(), provisionalUpdate.value()).value();
    }

    private void undoProvisionalUpdate(DatabaseUpdate update, long transactionId) {
        String mapName = update.mapName();
        String key = update.key();
        Update provisionalUpdate = this.getLockMap(mapName).get(key);
        if (provisionalUpdate == null) {
            return;
        }
        if (Objects.equal((Object)transactionId, (Object)provisionalUpdate.transactionId())) {
            this.getLockMap(mapName).remove(key);
        }
    }

    private boolean isLockedByAnotherTransaction(String mapName, String key, long transactionId) {
        Update update = this.getLockMap(mapName).get(key);
        return update != null && !Objects.equal((Object)transactionId, (Object)update.transactionId());
    }

    private boolean isLockedForUpdates(String mapName, String key) {
        return this.getLockMap(mapName).containsKey(key);
    }

    private boolean areTransactionsInProgress(String mapName) {
        return !this.getLockMap(mapName).isEmpty();
    }

    private class Update {
        private final long transactionId;
        private final byte[] value;

        public Update(long txId, byte[] value) {
            this.transactionId = txId;
            this.value = value;
        }

        public long transactionId() {
            return this.transactionId;
        }

        public byte[] value() {
            return this.value;
        }
    }
}

