/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.onosproject.store.consistent.impl.MeteringAgent;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.SetEvent;
import org.onosproject.store.service.SetEventListener;

public class DefaultDistributedSet<E>
implements DistributedSet<E> {
    private static final String CONTAINS = "contains";
    private static final String PRIMITIVE_NAME = "distributedSet";
    private static final String SIZE = "size";
    private static final String IS_EMPTY = "isEmpty";
    private static final String ITERATOR = "iterator";
    private static final String TO_ARRAY = "toArray";
    private static final String ADD = "add";
    private static final String REMOVE = "remove";
    private static final String CONTAINS_ALL = "containsAll";
    private static final String ADD_ALL = "addAll";
    private static final String RETAIN_ALL = "retainAll";
    private static final String REMOVE_ALL = "removeAll";
    private static final String CLEAR = "clear";
    private final String name;
    private final ConsistentMap<E, Boolean> backingMap;
    private final Map<SetEventListener<E>, MapEventListener<E, Boolean>> listenerMapping = Maps.newIdentityHashMap();
    private final MeteringAgent monitor;

    public DefaultDistributedSet(String name, boolean meteringEnabled, ConsistentMap<E, Boolean> backingMap) {
        this.name = name;
        this.backingMap = backingMap;
        this.monitor = new MeteringAgent(PRIMITIVE_NAME, name, meteringEnabled);
    }

    public int size() {
        MeteringAgent.Context timer = this.monitor.startTimer(SIZE);
        try {
            int n = this.backingMap.size();
            return n;
        }
        finally {
            timer.stop(null);
        }
    }

    public boolean isEmpty() {
        MeteringAgent.Context timer = this.monitor.startTimer(IS_EMPTY);
        try {
            boolean bl = this.backingMap.isEmpty();
            return bl;
        }
        finally {
            timer.stop(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        MeteringAgent.Context timer = this.monitor.startTimer(CONTAINS);
        try {
            boolean bl = this.backingMap.containsKey(o);
            return bl;
        }
        finally {
            timer.stop(null);
        }
    }

    public Iterator<E> iterator() {
        MeteringAgent.Context timer = this.monitor.startTimer(ITERATOR);
        try {
            Iterator iterator = this.backingMap.keySet().iterator();
            return iterator;
        }
        finally {
            timer.stop(null);
        }
    }

    public Object[] toArray() {
        MeteringAgent.Context timer = this.monitor.startTimer(TO_ARRAY);
        try {
            Object[] objectArray = this.backingMap.keySet().stream().toArray();
            return objectArray;
        }
        finally {
            timer.stop(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T[] toArray(T[] a) {
        MeteringAgent.Context timer = this.monitor.startTimer(TO_ARRAY);
        try {
            A[] AArray = this.backingMap.keySet().stream().toArray(size -> a);
            return AArray;
        }
        finally {
            timer.stop(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(E e) {
        MeteringAgent.Context timer = this.monitor.startTimer(ADD);
        try {
            boolean bl = this.backingMap.putIfAbsent(e, (Object)true) == null;
            return bl;
        }
        finally {
            timer.stop(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        MeteringAgent.Context timer = this.monitor.startTimer(REMOVE);
        try {
            boolean bl = this.backingMap.remove(o) != null;
            return bl;
        }
        finally {
            timer.stop(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection<?> c) {
        MeteringAgent.Context timer = this.monitor.startTimer(CONTAINS_ALL);
        try {
            boolean bl = c.stream().allMatch(this::contains);
            return bl;
        }
        finally {
            timer.stop(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection<? extends E> c) {
        MeteringAgent.Context timer = this.monitor.startTimer(ADD_ALL);
        try {
            boolean bl = c.stream().map(this::add).reduce(Boolean::logicalOr).orElse(false);
            return bl;
        }
        finally {
            timer.stop(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection<?> c) {
        MeteringAgent.Context timer = this.monitor.startTimer(RETAIN_ALL);
        try {
            HashSet retainSet = Sets.newHashSet(c);
            boolean bl = this.backingMap.keySet().stream().filter(k -> !retainSet.contains(k)).map(this::remove).reduce(Boolean::logicalOr).orElse(false);
            return bl;
        }
        finally {
            timer.stop(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection<?> c) {
        MeteringAgent.Context timer = this.monitor.startTimer(REMOVE_ALL);
        try {
            HashSet removeSet = Sets.newHashSet(c);
            boolean bl = this.backingMap.keySet().stream().filter(removeSet::contains).map(this::remove).reduce(Boolean::logicalOr).orElse(false);
            return bl;
        }
        finally {
            timer.stop(null);
        }
    }

    public void clear() {
        MeteringAgent.Context timer = this.monitor.startTimer(CLEAR);
        try {
            this.backingMap.clear();
        }
        finally {
            timer.stop(null);
        }
    }

    public void addListener(SetEventListener<E> listener) {
        MapEventListener mapEventListener = mapEvent -> {
            if (mapEvent.type() == MapEvent.Type.INSERT) {
                listener.event(new SetEvent(this.name, SetEvent.Type.ADD, mapEvent.key()));
            } else if (mapEvent.type() == MapEvent.Type.REMOVE) {
                listener.event(new SetEvent(this.name, SetEvent.Type.REMOVE, mapEvent.key()));
            }
        };
        if (this.listenerMapping.putIfAbsent(listener, mapEventListener) == null) {
            this.backingMap.addListener(mapEventListener);
        }
    }

    public void removeListener(SetEventListener<E> listener) {
        MapEventListener<E, Boolean> mapEventListener = this.listenerMapping.remove(listener);
        if (mapEventListener != null) {
            this.backingMap.removeListener(mapEventListener);
        }
    }
}

