/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import org.onosproject.core.ApplicationId;
import org.onosproject.store.consistent.impl.DatabaseManager;
import org.onosproject.store.consistent.impl.DefaultDistributedSet;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.Serializer;

public class DefaultDistributedSetBuilder<E>
implements DistributedSetBuilder<E> {
    private String name;
    private ConsistentMapBuilder<E, Boolean> mapBuilder;
    private boolean metering = true;

    public DefaultDistributedSetBuilder(DatabaseManager manager) {
        this.mapBuilder = manager.consistentMapBuilder();
        this.mapBuilder.withMeteringDisabled();
    }

    public DistributedSetBuilder<E> withName(String name) {
        this.mapBuilder.withName(name);
        this.name = name;
        return this;
    }

    public DistributedSetBuilder<E> withApplicationId(ApplicationId id) {
        this.mapBuilder.withApplicationId(id);
        return this;
    }

    public DistributedSetBuilder<E> withPurgeOnUninstall() {
        this.mapBuilder.withPurgeOnUninstall();
        return this;
    }

    public DistributedSetBuilder<E> withSerializer(Serializer serializer) {
        this.mapBuilder.withSerializer(serializer);
        return this;
    }

    public DistributedSetBuilder<E> withUpdatesDisabled() {
        this.mapBuilder.withUpdatesDisabled();
        return this;
    }

    public DistributedSetBuilder<E> withRelaxedReadConsistency() {
        this.mapBuilder.withRelaxedReadConsistency();
        return this;
    }

    public DistributedSetBuilder<E> withPartitionsDisabled() {
        this.mapBuilder.withPartitionsDisabled();
        return this;
    }

    public DistributedSetBuilder<E> withMeteringDisabled() {
        this.metering = false;
        return this;
    }

    public DistributedSet<E> build() {
        return new DefaultDistributedSet(this.name, this.metering, this.mapBuilder.build());
    }
}

