/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Supplier;
import org.onosproject.store.consistent.impl.CommitResponse;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.DefaultTransaction;
import org.onosproject.store.consistent.impl.DefaultTransactionalMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionalMap;

public class DefaultTransactionContext
implements TransactionContext {
    private static final String TX_NOT_OPEN_ERROR = "Transaction Context is not open";
    private final Map<String, DefaultTransactionalMap> txMaps = Maps.newConcurrentMap();
    private boolean isOpen = false;
    private final Database database;
    private final long transactionId;
    private final Supplier<ConsistentMapBuilder> mapBuilderSupplier;

    public DefaultTransactionContext(long transactionId, Database database, Supplier<ConsistentMapBuilder> mapBuilderSupplier) {
        this.transactionId = transactionId;
        this.database = (Database)Preconditions.checkNotNull((Object)database);
        this.mapBuilderSupplier = (Supplier)Preconditions.checkNotNull(mapBuilderSupplier);
    }

    public long transactionId() {
        return this.transactionId;
    }

    public void begin() {
        Preconditions.checkState((!this.isOpen ? 1 : 0) != 0, (Object)"Transaction Context is already open");
        this.isOpen = true;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public <K, V> TransactionalMap<K, V> getTransactionalMap(String mapName, Serializer serializer) {
        Preconditions.checkState((boolean)this.isOpen, (Object)TX_NOT_OPEN_ERROR);
        Preconditions.checkNotNull((Object)mapName);
        Preconditions.checkNotNull((Object)serializer);
        return this.txMaps.computeIfAbsent(mapName, name -> new DefaultTransactionalMap((String)name, this.mapBuilderSupplier.get().withName(name).withSerializer(serializer).build(), this, serializer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Preconditions.checkState((boolean)this.isOpen, (Object)TX_NOT_OPEN_ERROR);
        CommitResponse response = null;
        try {
            LinkedList updates = Lists.newLinkedList();
            this.txMaps.values().forEach(m -> updates.addAll(m.prepareDatabaseUpdates()));
            DefaultTransaction transaction = new DefaultTransaction(this.transactionId, updates);
            response = (CommitResponse)Futures.getUnchecked(this.database.prepareAndCommit(transaction));
        }
        finally {
            if (response != null && !response.success()) {
                this.abort();
            }
            this.isOpen = false;
        }
    }

    public void abort() {
        if (this.isOpen) {
            try {
                this.txMaps.values().forEach(m -> m.rollback());
            }
            finally {
                this.isOpen = false;
            }
        }
    }
}

