/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;

public final class Match<T> {
    private final boolean matchAny;
    private final T value;

    public static <T> Match<T> any() {
        return new Match<T>();
    }

    public static <T> Match<T> ifNull() {
        return Match.ifValue(null);
    }

    public static <T> Match<T> ifValue(T value) {
        return new Match<T>(value);
    }

    private Match() {
        this.matchAny = true;
        this.value = null;
    }

    private Match(T value) {
        this.matchAny = false;
        this.value = value;
    }

    public <V> Match<V> map(Function<T, V> mapper) {
        if (this.matchAny) {
            return Match.any();
        }
        if (this.value == null) {
            return Match.ifNull();
        }
        return Match.ifValue(mapper.apply(this.value));
    }

    public boolean matches(T other) {
        if (this.matchAny) {
            return true;
        }
        if (other == null) {
            return this.value == null;
        }
        if (this.value instanceof byte[]) {
            return Arrays.equals((byte[])this.value, (byte[])other);
        }
        return Objects.equals(this.value, other);
    }

    public int hashCode() {
        return Objects.hash(this.matchAny, this.value);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Match)) {
            return false;
        }
        Match that = (Match)other;
        return Objects.equals(this.matchAny, that.matchAny) && Objects.equals(this.value, that.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("matchAny", this.matchAny).add("value", this.value).toString();
    }
}

