/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public final class Result<V> {
    private final Status status;
    private final V value;

    public static <V> Result<V> ok(V value) {
        return new Result<V>(value, Status.OK);
    }

    public static <V> Result<V> locked() {
        return new Result<Object>(null, Status.LOCKED);
    }

    private Result(V value, Status status) {
        this.value = value;
        this.status = status;
    }

    public boolean success() {
        return this.status == Status.OK;
    }

    public Status status() {
        return this.status;
    }

    public V value() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.status});
    }

    public boolean equals(Object other) {
        if (!(other instanceof Result)) {
            return false;
        }
        Result that = (Result)other;
        return Objects.equals(this.value, that.value) && Objects.equals((Object)this.status, (Object)that.status);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("value", this.value).toString();
    }

    public static enum Status {
        OK,
        LOCKED;

    }
}

