/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.onlab.util.KryoNamespace;
import org.onosproject.store.consistent.impl.CommitResponse;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.DefaultTransaction;
import org.onosproject.store.consistent.impl.UpdateResult;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DatabaseUpdate;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.Transaction;
import org.onosproject.store.service.Versioned;

public class TransactionManager {
    private static final KryoNamespace KRYO_NAMESPACE = KryoNamespace.newBuilder().register(KryoNamespaces.BASIC).nextId(-1).register(new Class[]{Versioned.class}).register(new Class[]{DatabaseUpdate.class}).register(new Class[]{DatabaseUpdate.Type.class}).register(new Class[]{DefaultTransaction.class}).register(new Class[]{Transaction.State.class}).build();
    private final Serializer serializer = Serializer.using(Arrays.asList(KRYO_NAMESPACE), (Class[])new Class[0]);
    private final Database database;
    private final AsyncConsistentMap<Long, Transaction> transactions;

    public TransactionManager(Database database, ConsistentMapBuilder<Long, Transaction> mapBuilder) {
        this.database = (Database)Preconditions.checkNotNull((Object)database, (Object)"database cannot be null");
        this.transactions = mapBuilder.withName("onos-transactions").withSerializer(this.serializer).buildAsyncMap();
    }

    public CompletableFuture<CommitResponse> execute(Transaction transaction) {
        if (transaction.state() == Transaction.State.COMMITTED || transaction.state() == Transaction.State.ROLLEDBACK) {
            return this.transactions.remove((Object)transaction.id()).thenApply(v -> CommitResponse.success((List<UpdateResult<String, byte[]>>)ImmutableList.of()));
        }
        if (transaction.state() == Transaction.State.COMMITTING) {
            return this.commit(transaction);
        }
        if (transaction.state() == Transaction.State.ROLLINGBACK) {
            return this.rollback(transaction).thenApply(v -> CommitResponse.success((List<UpdateResult<String, byte[]>>)ImmutableList.of()));
        }
        return this.prepare(transaction).thenCompose(v -> v != false ? this.commit(transaction) : this.rollback(transaction));
    }

    public CompletableFuture<Collection<Transaction>> getTransactions() {
        return this.transactions.values().thenApply(c -> {
            Collection txns = c.stream().map(v -> (Transaction)v.value()).collect(Collectors.toList());
            return txns;
        });
    }

    private CompletableFuture<Boolean> prepare(Transaction transaction) {
        return ((CompletableFuture)this.transactions.put((Object)transaction.id(), (Object)transaction).thenCompose(v -> this.database.prepare(transaction))).thenCompose(status -> this.transactions.put((Object)transaction.id(), (Object)transaction.transition(status != false ? Transaction.State.COMMITTING : Transaction.State.ROLLINGBACK)).thenApply(v -> status));
    }

    private CompletableFuture<CommitResponse> commit(Transaction transaction) {
        return this.database.commit(transaction).whenComplete((r, e) -> this.transactions.put((Object)transaction.id(), (Object)transaction.transition(Transaction.State.COMMITTED)));
    }

    private CompletableFuture<CommitResponse> rollback(Transaction transaction) {
        return ((CompletableFuture)this.database.rollback(transaction).thenCompose(v -> this.transactions.put((Object)transaction.id(), (Object)transaction.transition(Transaction.State.ROLLEDBACK)))).thenApply(v -> CommitResponse.failure());
    }
}

