/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.core.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.ApplicationIdStore;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageException;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class ConsistentApplicationIdStore
implements ApplicationIdStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private AtomicCounter appIdCounter;
    private ConsistentMap<String, ApplicationId> registeredIds;
    private Map<String, ApplicationId> nameToAppIdCache = Maps.newConcurrentMap();
    private Map<Short, ApplicationId> idToAppIdCache = Maps.newConcurrentMap();
    private static final Serializer SERIALIZER = Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).nextId(300).build());

    @Activate
    public void activate() {
        this.appIdCounter = this.storageService.atomicCounterBuilder().withName("onos-app-id-counter").withPartitionsDisabled().build();
        this.registeredIds = this.storageService.consistentMapBuilder().withName("onos-app-ids").withPartitionsDisabled().withSerializer(SERIALIZER).build();
        this.primeAppIds();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public Set<ApplicationId> getAppIds() {
        this.primeAppIds();
        return ImmutableSet.copyOf(this.nameToAppIdCache.values());
    }

    public ApplicationId getAppId(Short id) {
        if (!this.idToAppIdCache.containsKey(id)) {
            this.primeAppIds();
        }
        return this.idToAppIdCache.get(id);
    }

    public ApplicationId getAppId(String name) {
        ApplicationId appId = this.nameToAppIdCache.computeIfAbsent(name, key -> {
            Versioned existingAppId = this.registeredIds.get(key);
            return existingAppId != null ? (ApplicationId)existingAppId.value() : null;
        });
        if (appId != null) {
            this.idToAppIdCache.putIfAbsent(appId.id(), appId);
        }
        return appId;
    }

    public ApplicationId registerApplication(String name) {
        ApplicationId appId = this.nameToAppIdCache.computeIfAbsent(name, key -> {
            Versioned existingAppId = this.registeredIds.get((Object)name);
            if (existingAppId == null) {
                int id = ((Long)Tools.retryable(() -> ((AtomicCounter)this.appIdCounter).incrementAndGet(), StorageException.class, (int)1, (int)2000).get()).intValue();
                DefaultApplicationId newAppId = new DefaultApplicationId(id, name);
                existingAppId = this.registeredIds.putIfAbsent((Object)name, (Object)newAppId);
                if (existingAppId != null) {
                    return (ApplicationId)existingAppId.value();
                }
                return newAppId;
            }
            return (ApplicationId)existingAppId.value();
        });
        this.idToAppIdCache.putIfAbsent(appId.id(), appId);
        return appId;
    }

    private void primeAppIds() {
        this.registeredIds.values().stream().map(Versioned::value).forEach(appId -> {
            this.nameToAppIdCache.putIfAbsent(appId.name(), (ApplicationId)appId);
            this.idToAppIdCache.putIfAbsent(appId.id(), (ApplicationId)appId);
        });
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

