/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.device.impl;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.mastership.MastershipTerm;
import org.onosproject.mastership.MastershipTermService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceClockService;
import org.onosproject.store.Timestamp;
import org.onosproject.store.impl.MastershipBasedTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DeviceClockManager
implements DeviceClockService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipTermService mastershipTermService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    protected NodeId localNodeId;
    private final AtomicLong ticker = new AtomicLong(0L);

    @Activate
    public void activate() {
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public Timestamp getTimestamp(DeviceId deviceId) {
        MastershipTerm term = this.mastershipTermService.getMastershipTerm(deviceId);
        if (term == null || !this.localNodeId.equals((Object)term.master())) {
            throw new IllegalStateException("Requesting timestamp for " + deviceId + " without mastership");
        }
        return new MastershipBasedTimestamp(term.termNumber(), this.ticker.incrementAndGet());
    }

    public boolean isTimestampAvailable(DeviceId deviceId) {
        MastershipTerm term = this.mastershipTermService.getMastershipTerm(deviceId);
        return term != null && this.localNodeId.equals((Object)term.master());
    }

    protected void bindMastershipTermService(MastershipTermService mastershipTermService) {
        this.mastershipTermService = mastershipTermService;
    }

    protected void unbindMastershipTermService(MastershipTermService mastershipTermService) {
        if (this.mastershipTermService == mastershipTermService) {
            this.mastershipTermService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }
}

