/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.ecmap;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Hasher;
import org.mapdb.Serializer;
import org.onosproject.store.ecmap.MapValue;
import org.onosproject.store.ecmap.PersistentStore;
import org.onosproject.store.serializers.KryoSerializer;

class MapDbPersistentStore<K, V>
implements PersistentStore<K, V> {
    private final ExecutorService executor;
    private final KryoSerializer serializer;
    private final DB database;
    private final Map<byte[], byte[]> items;

    MapDbPersistentStore(String filename, ExecutorService executor, KryoSerializer serializer) {
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor);
        this.serializer = (KryoSerializer)Preconditions.checkNotNull((Object)serializer);
        File databaseFile = new File(filename);
        this.database = DBMaker.newFileDB((File)databaseFile).make();
        this.items = this.database.createHashMap("items").keySerializer(Serializer.BYTE_ARRAY).valueSerializer(Serializer.BYTE_ARRAY).hasher(Hasher.BYTE_ARRAY).makeOrGet();
    }

    @Override
    public void readInto(Map<K, MapValue<V>> items) {
        this.items.forEach((keyBytes, valueBytes) -> {
            MapValue cfr_ignored_0 = (MapValue)items.put((K)this.serializer.decode(keyBytes), (MapValue<V>)this.serializer.decode(valueBytes));
        });
    }

    @Override
    public void update(K key, MapValue<V> value) {
        this.executor.submit(() -> this.updateInternal(key, value));
    }

    @Override
    public void remove(K key) {
        this.executor.submit(() -> this.removeInternal(key));
    }

    private void updateInternal(K key, MapValue<V> newValue) {
        byte[] keyBytes = this.serializer.encode(key);
        this.items.compute(keyBytes, (k, existingBytes) -> {
            MapValue existing;
            MapValue mapValue2 = existing = existingBytes == null ? null : (MapValue)this.serializer.decode(existingBytes);
            if (existing == null || newValue.isNewerThan(existing)) {
                return this.serializer.encode((Object)newValue);
            }
            return existingBytes;
        });
        this.database.commit();
    }

    private void removeInternal(K key) {
        byte[] keyBytes = this.serializer.encode(key);
        this.items.remove(keyBytes);
        this.database.commit();
    }
}

