/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.ecmap;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.onosproject.store.Timestamp;

public class MapValue<V>
implements Comparable<MapValue<V>> {
    private final Timestamp timestamp;
    private final V value;

    public static <U> MapValue<U> tombstone(Timestamp timestamp) {
        return new MapValue<Object>(null, timestamp);
    }

    public MapValue(V value, Timestamp timestamp) {
        this.value = value;
        this.timestamp = timestamp;
    }

    public boolean isTombstone() {
        return this.value == null;
    }

    public boolean isAlive() {
        return this.value != null;
    }

    public Timestamp timestamp() {
        return this.timestamp;
    }

    public V get() {
        return this.value;
    }

    @Override
    public int compareTo(MapValue<V> o) {
        return this.timestamp.compareTo((Object)o.timestamp);
    }

    public boolean isNewerThan(MapValue<V> other) {
        return this.timestamp.isNewerThan(other.timestamp);
    }

    public boolean isNewerThan(Timestamp timestamp) {
        return this.timestamp.isNewerThan(timestamp);
    }

    public Digest digest() {
        return new Digest(this.timestamp, this.isTombstone());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.timestamp, this.value});
    }

    public boolean equals(Object other) {
        if (other instanceof MapValue) {
            MapValue that = (MapValue)other;
            return Objects.equal((Object)this.timestamp, (Object)that.timestamp) && Objects.equal(this.value, that.value);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("timestamp", (Object)this.timestamp).add("value", this.value).toString();
    }

    private MapValue() {
        this.timestamp = null;
        this.value = null;
    }

    public static class Digest {
        private final Timestamp timestamp;
        private final boolean isTombstone;

        public Digest(Timestamp timestamp, boolean isTombstone) {
            this.timestamp = timestamp;
            this.isTombstone = isTombstone;
        }

        public Timestamp timestamp() {
            return this.timestamp;
        }

        public boolean isTombstone() {
            return this.isTombstone;
        }

        public boolean isNewerThan(Digest other) {
            return this.timestamp.isNewerThan(other.timestamp);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.timestamp, this.isTombstone});
        }

        public boolean equals(Object other) {
            if (other instanceof Digest) {
                Digest that = (Digest)other;
                return Objects.equal((Object)this.timestamp, (Object)that.timestamp) && Objects.equal((Object)this.isTombstone, (Object)that.isTombstone);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("timestamp", (Object)this.timestamp).add("isTombstone", this.isTombstone).toString();
        }
    }
}

