/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.ecmap;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.onosproject.store.ecmap.MapValue;

final class UpdateEntry<K, V> {
    private final K key;
    private final MapValue<V> value;

    public UpdateEntry(K key, MapValue<V> value) {
        this.key = Preconditions.checkNotNull(key);
        this.value = value;
    }

    public K key() {
        return this.key;
    }

    public MapValue<V> value() {
        return this.value;
    }

    public boolean isNewerThan(UpdateEntry<K, V> other) {
        return other == null || other.value == null || this.value != null && this.value.isNewerThan(other.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("key", this.key()).add("value", this.value).toString();
    }

    private UpdateEntry() {
        this.key = null;
        this.value = null;
    }
}

