/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.host.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.KryoNamespace;
import org.onosproject.event.Event;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostStore;
import org.onosproject.net.host.HostStoreDelegate;
import org.onosproject.net.host.PortAddresses;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.LogicalClockService;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class ECHostStore
extends AbstractStore<HostEvent, HostStoreDelegate>
implements HostStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LogicalClockService clockService;
    private final SetMultimap<ConnectPoint, Host> locations = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private final SetMultimap<ConnectPoint, PortAddresses> portAddresses = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private EventuallyConsistentMap<HostId, DefaultHost> hosts;
    private EventuallyConsistentMapListener<HostId, DefaultHost> hostLocationTracker = new HostLocationTracker();

    @Activate
    public void activate() {
        KryoNamespace.Builder hostSerializer = KryoNamespace.newBuilder().register(KryoNamespaces.API);
        this.hosts = this.storageService.eventuallyConsistentMapBuilder().withName("onos-hosts").withSerializer(hostSerializer).withTimestampProvider((k, v) -> this.clockService.getTimestamp()).build();
        this.hosts.addListener(this.hostLocationTracker);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.hosts.removeListener(this.hostLocationTracker);
        this.hosts.destroy();
        this.locations.clear();
        this.portAddresses.clear();
        this.log.info("Stopped");
    }

    public HostEvent createOrUpdateHost(ProviderId providerId, HostId hostId, HostDescription hostDescription) {
        DefaultHost currentHost = (DefaultHost)this.hosts.get((Object)hostId);
        if (currentHost == null) {
            DefaultHost newhost = new DefaultHost(providerId, hostId, hostDescription.hwAddress(), hostDescription.vlan(), hostDescription.location(), (Set)ImmutableSet.copyOf((Collection)hostDescription.ipAddress()), new Annotations[]{hostDescription.annotations()});
            this.hosts.put((Object)hostId, (Object)newhost);
            return new HostEvent(HostEvent.Type.HOST_ADDED, (Host)newhost);
        }
        return this.updateHost(providerId, hostId, hostDescription, currentHost);
    }

    public HostEvent removeHost(HostId hostId) {
        Host host = (Host)this.hosts.remove((Object)hostId);
        return host != null ? new HostEvent(HostEvent.Type.HOST_REMOVED, host) : null;
    }

    public int getHostCount() {
        return this.hosts.size();
    }

    public Iterable<Host> getHosts() {
        return ImmutableSet.copyOf((Collection)this.hosts.values());
    }

    public Host getHost(HostId hostId) {
        return (Host)this.hosts.get((Object)hostId);
    }

    public Set<Host> getHosts(VlanId vlanId) {
        return this.filter(this.hosts.values(), host -> Objects.equals(host.vlan(), vlanId));
    }

    public Set<Host> getHosts(MacAddress mac) {
        return this.filter(this.hosts.values(), host -> Objects.equals(host.mac(), mac));
    }

    public Set<Host> getHosts(IpAddress ip) {
        return this.filter(this.hosts.values(), host -> host.ipAddresses().contains(ip));
    }

    public Set<Host> getConnectedHosts(ConnectPoint connectPoint) {
        return ImmutableSet.copyOf((Collection)this.locations.get((Object)connectPoint));
    }

    public Set<Host> getConnectedHosts(DeviceId deviceId) {
        return ImmutableMultimap.copyOf(this.locations).entries().stream().filter(entry -> ((ConnectPoint)entry.getKey()).deviceId().equals((Object)deviceId)).map(entry -> (Host)entry.getValue()).collect(Collectors.toSet());
    }

    public void updateAddressBindings(PortAddresses addresses) {
        this.portAddresses.put((Object)addresses.connectPoint(), (Object)addresses);
    }

    public void removeAddressBindings(PortAddresses addresses) {
        this.portAddresses.remove((Object)addresses.connectPoint(), (Object)addresses);
    }

    public void clearAddressBindings(ConnectPoint connectPoint) {
        this.portAddresses.removeAll((Object)connectPoint);
    }

    public Set<PortAddresses> getAddressBindings() {
        return ImmutableSet.copyOf((Collection)this.portAddresses.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PortAddresses> getAddressBindingsForPort(ConnectPoint connectPoint) {
        SetMultimap<ConnectPoint, PortAddresses> setMultimap = this.portAddresses;
        synchronized (setMultimap) {
            Set addresses = this.portAddresses.get((Object)connectPoint);
            return addresses == null ? Collections.emptySet() : ImmutableSet.copyOf((Collection)addresses);
        }
    }

    private Set<Host> filter(Collection<DefaultHost> collection, Predicate<DefaultHost> predicate) {
        return collection.stream().filter(predicate).collect(Collectors.toSet());
    }

    private HostEvent updateHost(ProviderId providerId, HostId hostId, HostDescription descr, DefaultHost currentHost) {
        boolean hostMoved;
        boolean bl = hostMoved = !currentHost.location().equals((Object)descr.location());
        if (hostMoved || !currentHost.ipAddresses().containsAll(descr.ipAddress()) || !descr.annotations().keys().isEmpty()) {
            HashSet addresses = Sets.newHashSet((Iterable)currentHost.ipAddresses());
            addresses.addAll(descr.ipAddress());
            DefaultAnnotations annotations = DefaultAnnotations.merge((DefaultAnnotations)((DefaultAnnotations)currentHost.annotations()), (SparseAnnotations)descr.annotations());
            DefaultHost updatedHost = new DefaultHost(providerId, currentHost.id(), currentHost.mac(), currentHost.vlan(), descr.location(), (Set)addresses, new Annotations[]{annotations});
            this.hosts.put((Object)hostId, (Object)updatedHost);
            this.locations.remove((Object)currentHost.location(), (Object)currentHost);
            this.locations.put((Object)updatedHost.location(), (Object)updatedHost);
            HostEvent.Type eventType = hostMoved ? HostEvent.Type.HOST_MOVED : HostEvent.Type.HOST_UPDATED;
            return new HostEvent(eventType, (Host)updatedHost);
        }
        return null;
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindClockService(LogicalClockService logicalClockService) {
        this.clockService = logicalClockService;
    }

    protected void unbindClockService(LogicalClockService logicalClockService) {
        if (this.clockService == logicalClockService) {
            this.clockService = null;
        }
    }

    private class HostLocationTracker
    implements EventuallyConsistentMapListener<HostId, DefaultHost> {
        private HostLocationTracker() {
        }

        public void event(EventuallyConsistentMapEvent<HostId, DefaultHost> event) {
            DefaultHost host = (DefaultHost)Preconditions.checkNotNull((Object)event.value());
            if (event.type() == EventuallyConsistentMapEvent.Type.PUT) {
                boolean isNew = ECHostStore.this.locations.put((Object)host.location(), (Object)host);
                ECHostStore.this.notifyDelegate((Event)new HostEvent(isNew ? HostEvent.Type.HOST_ADDED : HostEvent.Type.HOST_UPDATED, (Host)host));
            } else if (event.type() == EventuallyConsistentMapEvent.Type.REMOVE && ECHostStore.this.locations.remove((Object)host.location(), (Object)host)) {
                ECHostStore.this.notifyDelegate((Event)new HostEvent(HostEvent.Type.HOST_REMOVED, (Host)host));
            }
        }
    }
}

