/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.newresource.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.net.newresource.ResourceConsumer;
import org.onosproject.net.newresource.ResourcePath;
import org.onosproject.net.newresource.ResourceStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionException;
import org.onosproject.store.service.TransactionalMap;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=false)
@Service
@Beta
public class ConsistentResourceStore
implements ResourceStore {
    private static final Logger log = LoggerFactory.getLogger(ConsistentResourceStore.class);
    private static final String CONSUMER_MAP = "onos-resource-consumers";
    private static final String CHILD_MAP = "onos-resource-children";
    private static final Serializer SERIALIZER = Serializer.using(Arrays.asList(KryoNamespaces.BASIC, KryoNamespaces.API), (Class[])new Class[0]);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService service;
    private ConsistentMap<ResourcePath, ResourceConsumer> consumerMap;
    private ConsistentMap<ResourcePath, List<ResourcePath>> childMap;

    @Activate
    public void activate() {
        this.consumerMap = this.service.consistentMapBuilder().withName(CONSUMER_MAP).withSerializer(SERIALIZER).build();
        this.childMap = this.service.consistentMapBuilder().withName(CHILD_MAP).withSerializer(SERIALIZER).build();
    }

    public Optional<ResourceConsumer> getConsumer(ResourcePath resource) {
        Preconditions.checkNotNull((Object)resource);
        Versioned consumer = this.consumerMap.get((Object)resource);
        if (consumer == null) {
            return Optional.empty();
        }
        return Optional.of(consumer.value());
    }

    public boolean register(List<ResourcePath> resources) {
        Preconditions.checkNotNull(resources);
        TransactionContext tx = this.service.transactionContextBuilder().build();
        tx.begin();
        try {
            TransactionalMap childTxMap = tx.getTransactionalMap(CHILD_MAP, SERIALIZER);
            Map<ResourcePath, List<ResourcePath>> resourceMap = resources.stream().filter(x -> x.parent().isPresent()).collect(Collectors.groupingBy(x -> (ResourcePath)x.parent().get()));
            for (Map.Entry<ResourcePath, List<ResourcePath>> entry : resourceMap.entrySet()) {
                if (!this.isRegistered((TransactionalMap<ResourcePath, List<ResourcePath>>)childTxMap, entry.getKey())) {
                    return this.abortTransaction(tx);
                }
                if (this.appendValues(childTxMap, entry.getKey(), entry.getValue())) continue;
                return this.abortTransaction(tx);
            }
            return this.commitTransaction(tx);
        }
        catch (TransactionException e) {
            log.error("Exception thrown, abort the transaction", (Throwable)e);
            return this.abortTransaction(tx);
        }
    }

    public boolean unregister(List<ResourcePath> resources) {
        Preconditions.checkNotNull(resources);
        TransactionContext tx = this.service.transactionContextBuilder().build();
        tx.begin();
        try {
            TransactionalMap childTxMap = tx.getTransactionalMap(CHILD_MAP, SERIALIZER);
            TransactionalMap consumerTxMap = tx.getTransactionalMap(CONSUMER_MAP, SERIALIZER);
            Map<ResourcePath, List<ResourcePath>> resourceMap = resources.stream().filter(x -> x.parent().isPresent()).collect(Collectors.groupingBy(x -> (ResourcePath)x.parent().get()));
            for (Map.Entry<ResourcePath, List<ResourcePath>> entry : resourceMap.entrySet()) {
                if (entry.getValue().stream().anyMatch(x -> consumerTxMap.get(x) != null)) {
                    return this.abortTransaction(tx);
                }
                if (this.removeValues(childTxMap, entry.getKey(), entry.getValue())) continue;
                return this.abortTransaction(tx);
            }
            return this.commitTransaction(tx);
        }
        catch (TransactionException e) {
            log.error("Exception thrown, abort the transaction", (Throwable)e);
            return this.abortTransaction(tx);
        }
    }

    public boolean allocate(List<ResourcePath> resources, ResourceConsumer consumer) {
        Preconditions.checkNotNull(resources);
        Preconditions.checkNotNull((Object)consumer);
        TransactionContext tx = this.service.transactionContextBuilder().build();
        tx.begin();
        try {
            TransactionalMap childTxMap = tx.getTransactionalMap(CHILD_MAP, SERIALIZER);
            TransactionalMap consumerTxMap = tx.getTransactionalMap(CONSUMER_MAP, SERIALIZER);
            for (ResourcePath resource : resources) {
                if (!this.isRegistered((TransactionalMap<ResourcePath, List<ResourcePath>>)childTxMap, resource)) {
                    return this.abortTransaction(tx);
                }
                ResourceConsumer oldValue = (ResourceConsumer)consumerTxMap.put((Object)resource, (Object)consumer);
                if (oldValue == null) continue;
                return this.abortTransaction(tx);
            }
            return this.commitTransaction(tx);
        }
        catch (TransactionException e) {
            log.error("Exception thrown, abort the transaction", (Throwable)e);
            return this.abortTransaction(tx);
        }
    }

    public boolean release(List<ResourcePath> resources, List<ResourceConsumer> consumers) {
        Preconditions.checkNotNull(resources);
        Preconditions.checkNotNull(consumers);
        Preconditions.checkArgument((resources.size() == consumers.size() ? 1 : 0) != 0);
        TransactionContext tx = this.service.transactionContextBuilder().build();
        tx.begin();
        try {
            TransactionalMap consumerTxMap = tx.getTransactionalMap(CONSUMER_MAP, SERIALIZER);
            Iterator<ResourcePath> resourceIte = resources.iterator();
            Iterator<ResourceConsumer> consumerIte = consumers.iterator();
            while (resourceIte.hasNext() && consumerIte.hasNext()) {
                ResourceConsumer consumer;
                ResourcePath resource = resourceIte.next();
                if (consumerTxMap.remove((Object)resource, (Object)(consumer = consumerIte.next()))) continue;
                return this.abortTransaction(tx);
            }
            return this.commitTransaction(tx);
        }
        catch (TransactionException e) {
            log.error("Exception thrown, abort the transaction", (Throwable)e);
            return this.abortTransaction(tx);
        }
    }

    public Collection<ResourcePath> getResources(ResourceConsumer consumer) {
        Preconditions.checkNotNull((Object)consumer);
        return this.consumerMap.entrySet().stream().filter(x -> ((ResourceConsumer)((Versioned)x.getValue()).value()).equals(consumer)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public <T> Collection<ResourcePath> getAllocatedResources(ResourcePath parent, Class<T> cls) {
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull(cls);
        Versioned children = this.childMap.get((Object)parent);
        if (children == null) {
            return Collections.emptyList();
        }
        return ((List)children.value()).stream().filter(x -> x.lastComponent().getClass().equals(cls)).filter(arg_0 -> this.consumerMap.containsKey(arg_0)).collect(Collectors.toList());
    }

    private boolean abortTransaction(TransactionContext tx) {
        tx.abort();
        return false;
    }

    private boolean commitTransaction(TransactionContext tx) {
        tx.commit();
        return true;
    }

    private <K, V> boolean appendValues(TransactionalMap<K, List<V>> map, K key, List<V> values) {
        List oldValues = (List)map.get(key);
        if (oldValues == null) {
            return map.replace(key, (Object)oldValues, new ArrayList<V>(values));
        }
        LinkedHashSet<V> oldSet = new LinkedHashSet<V>(oldValues);
        if (oldSet.containsAll(values)) {
            return true;
        }
        oldSet.addAll(values);
        return map.replace(key, (Object)oldValues, new ArrayList(oldSet));
    }

    private <K, V> boolean removeValues(TransactionalMap<K, List<V>> map, K key, List<V> values) {
        List oldValues = (List)map.get(key);
        if (oldValues == null) {
            return map.replace(key, (Object)oldValues, new ArrayList());
        }
        LinkedHashSet oldSet = new LinkedHashSet(oldValues);
        if (values.stream().allMatch(x -> !oldSet.contains(x))) {
            return true;
        }
        oldSet.removeAll(values);
        return map.replace(key, (Object)oldValues, new ArrayList(oldSet));
    }

    private boolean isRegistered(TransactionalMap<ResourcePath, List<ResourcePath>> map, ResourcePath resource) {
        if (resource.isRoot()) {
            return true;
        }
        List value = (List)map.get(resource.parent().get());
        return value != null && value.contains(resource);
    }

    protected void bindService(StorageService storageService) {
        this.service = storageService;
    }

    protected void unbindService(StorageService storageService) {
        if (this.service == storageService) {
            this.service = null;
        }
    }
}

