/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.resource.device.DeviceResourceStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionalMap;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class ConsistentDeviceResourceStore
implements DeviceResourceStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String PORT_ALLOCATIONS = "PortAllocations";
    private static final String INTENT_MAPPING = "IntentMapping";
    private static final String INTENT_ALLOCATIONS = "PortIntentAllocations";
    private static final Serializer SERIALIZER = Serializer.using((KryoNamespace)KryoNamespaces.API);
    private ConsistentMap<Port, IntentId> portAllocMap;
    private ConsistentMap<IntentId, Set<Port>> intentAllocMap;
    private ConsistentMap<IntentId, Set<IntentId>> intentMapping;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;

    @Activate
    public void activate() {
        this.portAllocMap = this.storageService.consistentMapBuilder().withName(PORT_ALLOCATIONS).withSerializer(SERIALIZER).build();
        this.intentAllocMap = this.storageService.consistentMapBuilder().withName(INTENT_ALLOCATIONS).withSerializer(SERIALIZER).build();
        this.intentMapping = this.storageService.consistentMapBuilder().withName(INTENT_MAPPING).withSerializer(SERIALIZER).build();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    private TransactionalMap<Port, IntentId> getPortAllocs(TransactionContext tx) {
        return tx.getTransactionalMap(PORT_ALLOCATIONS, SERIALIZER);
    }

    private TransactionalMap<IntentId, Set<Port>> getIntentAllocs(TransactionContext tx) {
        return tx.getTransactionalMap(INTENT_ALLOCATIONS, SERIALIZER);
    }

    private TransactionContext getTxContext() {
        return this.storageService.transactionContextBuilder().build();
    }

    public Set<Port> getFreePorts(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId);
        HashSet<Port> freePorts = new HashSet<Port>();
        for (Port port : this.deviceService.getPorts(deviceId)) {
            if (this.portAllocMap.containsKey((Object)port)) continue;
            freePorts.add(port);
        }
        return freePorts;
    }

    public boolean allocatePorts(Set<Port> ports, IntentId intentId) {
        Preconditions.checkNotNull(ports);
        Preconditions.checkArgument((ports.size() > 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)intentId);
        TransactionContext tx = this.getTxContext();
        tx.begin();
        try {
            TransactionalMap<Port, IntentId> portAllocs = this.getPortAllocs(tx);
            for (Port port : ports) {
                if (portAllocs.putIfAbsent((Object)port, (Object)intentId) == null) continue;
                throw new Exception("Port already allocated " + port.toString());
            }
            TransactionalMap<IntentId, Set<Port>> intentAllocs = this.getIntentAllocs(tx);
            intentAllocs.put((Object)intentId, ports);
            tx.commit();
        }
        catch (Exception e) {
            this.log.error("Exception thrown, rolling back", (Throwable)e);
            tx.abort();
            return false;
        }
        return true;
    }

    public Set<Port> getAllocations(IntentId intentId) {
        if (!this.intentAllocMap.containsKey((Object)intentId)) {
            Collections.emptySet();
        }
        return (Set)this.intentAllocMap.get((Object)intentId).value();
    }

    public IntentId getAllocations(Port port) {
        if (!this.portAllocMap.containsKey((Object)port)) {
            return null;
        }
        return (IntentId)this.portAllocMap.get((Object)port).value();
    }

    public Set<IntentId> getMapping(IntentId intentId) {
        Versioned result = this.intentMapping.get((Object)intentId);
        if (result != null) {
            return (Set)result.value();
        }
        return null;
    }

    public boolean allocateMapping(IntentId keyIntentId, IntentId valIntentId) {
        Versioned versionedIntents = this.intentMapping.get((Object)keyIntentId);
        if (versionedIntents == null) {
            HashSet<IntentId> newSet = new HashSet<IntentId>();
            newSet.add(valIntentId);
            this.intentMapping.put((Object)keyIntentId, newSet);
        } else {
            ((Set)versionedIntents.value()).add(valIntentId);
        }
        return true;
    }

    public void releaseMapping(IntentId intentId) {
        for (IntentId intent : this.intentMapping.keySet()) {
            Set mapping = (Set)this.intentMapping.get((Object)intent).value();
            if (!mapping.remove(intentId)) continue;
            return;
        }
    }

    public boolean releasePorts(IntentId intentId) {
        Preconditions.checkNotNull((Object)intentId);
        TransactionContext tx = this.getTxContext();
        tx.begin();
        try {
            TransactionalMap<IntentId, Set<Port>> intentAllocs = this.getIntentAllocs(tx);
            Set ports = (Set)intentAllocs.get((Object)intentId);
            intentAllocs.remove((Object)intentId);
            TransactionalMap<Port, IntentId> portAllocs = this.getPortAllocs(tx);
            for (Port port : ports) {
                portAllocs.remove((Object)port);
            }
            tx.commit();
        }
        catch (Exception e) {
            this.log.error("Exception thrown, rolling back", (Throwable)e);
            tx.abort();
            return false;
        }
        return true;
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }
}

